/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *  $Id$
 *
 *	ファイル名	:	TFLibWorkSessionWrapper.h
 *	クラス名		:	CTFLibWorkSessionWrapper
 *	継承			:	CTFLibWorkSession
 *
 *	機能　		:	Onionのメソッド系を処理するクラス
 *					
 *
 */
#ifndef TF_LIB_WORKSESSIONWRAPPER_H
#define	TF_LIB_WORKSESSIONWRAPPER_H	1

#include "TFLibWorkSession.h"
#include "TFResourceProp.h"
#include "TFDavResourceList.h"
#include "TFWsTransactionHandler.h"
#include "TFXmlBodyPropfind.h"
#include "TFResponseHeaderReceiver.h"
#include <onion/DavResourceNode.h>
#include <onion/DavRequest.h>

TF_BEGIN_CLASSEXPORT

class TF_EXPORT CTFLibWorkSessionWrapper :
	public CTFLibWorkSession
{
public:
	CTFLibWorkSessionWrapper(void);
	~CTFLibWorkSessionWrapper(void);

	void SetRequestLicense(bool bUseLicense);

	virtual void OnResourceFound(CDavRequest* pReq, CDavResourceNode *pNode);
	virtual void OnSearchResponse(CDavRequest* pReq, XNS(DOMNode)* pNode);

	virtual void OnCreateRequest(CDavRequest *pReq);
	virtual void OnPreSendRequest(CDavRequest* pReq);
	virtual void OnPreRecvResponse(CDavRequest* pReq);
	virtual void OnPostSendRequest(CDavRequest* pReq);
	virtual void OnPostRecvResponse(CDavRequest* pReq);
	virtual void OnDestroyRequest(CDavRequest* pReq);

	virtual OI_RESULT ProcessExtraHeader(CDavRequest* pReq, const char* pszName, OI_STRLIST_A& vecValues);

	// progress
	virtual bool OnSendProgress(CDavRequest* pReq, OI_SIZE_T unProgress, OI_SIZE_T unTotal);
	virtual bool OnReceiveProgress(CDavRequest* pReq, OI_SIZE_T unProgress, OI_SIZE_T unTotal, bool bCLength);


	// リスト表示支援用ハンドラ
	bool OnShowSearchResponse(CTFResourceProp* pItem);
	bool OnShowResource(CTFResourceProp* pItem);

	// メソッド
	OI_RESULT DoTFOptions(const TFXMLCh* pszURI, OI_HEADERMAP* pHeaders);
	OI_RESULT DoTFGet(const TFXMLCh *pszURI, const char *pszLocalPath, OICRANGE* pRange=NULL);
	OI_RESULT DoTFGet(const TFXMLCh* pszURI, int hFile, OICRANGE* pRange=NULL);
	OI_RESULT DoTFDelete(const TFXMLCh* pszURI, const char* pszIfHeader);
	OI_RESULT DoTFPut(const TFXMLCh* pszURI, const char* pszLocalPath,
					  const char *pszIfHeader = NULL, const char *pszContentType = NULL);
	OI_RESULT DoTFPut(const TFXMLCh* pszURI, int hFile, const char* pszIfHeader = NULL, const char* pszContentType=NULL);
	OI_RESULT DoTFPropfind(const TFXMLCh* pszURI, CTFResourceProp** ppItem, OI_PFIND_DEPTH enuDepth = D_PFIND_ONE);

	OI_RESULT DoTFPropfindCustom(const TFXMLCh*		pszURI,
								 CTFResourceProp**	ppItem,
                                 OI_PFIND_DEPTH		enuDepth	= D_PFIND_ONE,
                                 TFLIVEPROP			enuLive		= LP_NONE,
                                 TFLIVEPROPTF		enuLiveEx	= LP_EX_NONE,
                                 TFDEADPROP			enuDead		= DP_NONE);

	OI_RESULT DoTFLock(const TFXMLCh* pszURI, CDavLock *pLock, const char *pszIfHeader= NULL);
	OI_RESULT DoTFUnlock(const TFXMLCh* pszURI, const char *pszLockToken);
	OI_RESULT DoTFCopy(const TFXMLCh* pszSrc, const TFXMLCh* pszDest, CRBPVDXmlCopy *pXml=NULL, 
					   bool bOverwrite  = false, const char *pszIfHeader=NULL);
	OI_RESULT DoTFProppatch(const TFXMLCh* pszURI, CRBPVDXmlProppatch* pXml, const char* pszIfHeader=NULL);
	OI_RESULT DoTFMove(const TFXMLCh* pszSrc, const TFXMLCh* pszDest, CRBPVDXmlMove *pXml=NULL, 
					   bool bOverwrite  = false, const char *pszIfHeader=NULL);
	OI_RESULT DoTFMkcol(const TFXMLCh* pszURI, const char* pszIfHeader=NULL, CRequestBodyProvider* pBodyProvider=NULL);

	OI_RESULT DoTFSearch(const TFXMLCh* pszURI, CTFResourceProp** ppItem, CRBPVDXmlSearch *pXml);

	// メソッド拡張
//	OI_RESULT DoTFPropFind2(const TFXMLCh* pszURI, CTFResourceProp** ppItem, OI_PFIND_DEPTH enuDepth = D_PFIND_ONE);

protected:
	bool						m_bUseLicense;			//< ライセンスが必要なリクエストの時TRUE

private:
	CTFDavResourceList*			m_pItemList;		//< PROPFIND/SEARCHで返却されたリソースリスト
	CTFResponseHeaderReceiver	m_cReceiver;
};

TF_END_CLASSEXPORT
#endif

