/**
 *  Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *  $Id$
 *
 *	ファイル名	: TFLocalFileItem.h
 *	クラス名	: CTFLocalFileItem
 *	継承		: CTFObject 
 *
 *	機能　		: ローカルファイル自体を示すインタフェース
 *
 *
 */
#ifndef TFLIB_CTFLOCALFILEITEM_H
#define TFLIB_CTFLOCALFILEITEM_H	1

#include "TFObject.h"
#include "TFLibPublic.h"

TF_BEGIN_CLASSEXPORT

typedef enum tagTF_FOLDER_TYPE
{
	TF_FOLDER_TYPE_NOTFOLDER = 1,	//< フォルダではない
	TF_FOLDER_TYPE_NORMAL,			//< 通常フォルダ
	TF_FOLDER_TYPE_SAFTY,			//< 通常フォルダで安全フォルダ
	TF_FOLDER_TYPE_TEMP				//< 一時的なフォルダ
} TF_FOLDER_TYPE, *PTF_FOLDER_TYPE;

class TF_EXPORT CTFLocalFileItem :public CTFObject
{
public:
	CTFLocalFileItem(void);
	virtual ~CTFLocalFileItem(void);
	virtual void Import(const CTFObject& source);

	virtual void            SetURI(const TFXMLCh* pszURI) {};
	virtual const TFXMLCh*	GetURI(void) const { return NULL;};
	
	virtual int GetPath(int iFlags, void** ppBuffer, int* piSize) const;
	virtual int SetPath(int iFlags, void* pBuffer, int iSize);

	void SetContentType(const char* pszContentType)
	{
		if (pszContentType != NULL)
			m_strContentType = "";
		else
			m_strContentType = pszContentType;
	}

	const char* GetContentType(void)
	{
		return m_strContentType.c_str();
	}

	/**
	 * ファイルサイズを取得する
	 *
	 *	@param void
	 *	@return TF_SIZE_T
	 */
	TF_SIZE_T GetSize(void) const;

	/**
	 *	ファイルサイズを設定する
	 *
	 *	@param nSize	TF_SIZE_T
	 *	@return void
	 */
	void SetSize(TF_SIZE_T nSize);

	enum tagTF_FILE_ATTR
	{
		TF_FILE_ATTRIBUTE_READONLY				= 0x00000001,          
		TF_FILE_ATTRIBUTE_HIDDEN				= 0x00000002,
		TF_FILE_ATTRIBUTE_SYSTEM				= 0x00000004,
		TF_FILE_ATTRIBUTE_DIRECTORY				= 0x00000010,
		TF_FILE_ATTRIBUTE_ARCHIVE				= 0x00000020,
		TF_FILE_ATTRIBUTE_DEVICE				= 0x00000040,
		TF_FILE_ATTRIBUTE_NORMAL				= 0x00000080,
		TF_FILE_ATTRIBUTE_TEMPORARY				= 0x00000100,
		TF_FILE_ATTRIBUTE_SPARSE_FILE			= 0x00000200,
		TF_FILE_ATTRIBUTE_REPARSE_POINT			= 0x00000400,
		TF_FILE_ATTRIBUTE_COMPRESSED			= 0x00000800,
		TF_FILE_ATTRIBUTE_OFFLINE				= 0x00001000,
		TF_FILE_ATTRIBUTE_NOT_CONTENT_INDEXED	= 0x00002000,
		TF_FILE_ATTRIBUTE_ENCRYPTED				= 0x00004000,
		TF_FILE_ATTRIBUTE_LINK					= 0x00008000		// リンクファイル
	} TF_FILE_ATTR;

	void SetAttributes(TF_SIZE_T nAttribute);

	TF_SIZE_T GetAttributes(void);

	/**
	 *	内部に保持しているパスをconst char*(ANSI)で取得する
	 *
	 *	@param void
	 *	@return const TFXMLCh*
	 *	(note)
	 *	nullが戻ってきた場合は失敗したことになります。
	 */
	virtual const char*    GetPathA(void) { return NULL; };

	/**
	 *	内部に保持しているパスをTFXMLCh*(wide)で取得する
	 *
	 *	@param void
	 *	@return const TFXMLCh*
	 *	(note)
	 *	nullが戻ってきた場合は失敗したことになります。
	 */
	virtual const TFXMLCh* GetPathW(void) { return NULL; };

	/**
	 * このアイテムのファイルディスクリプタを取得する
	 * @return int 		ディスクリプタ
	 */
	virtual int GetFD(void);

	/**
	 * このアイテムのディスクリプタを設定する
	 * @param	nFD		int		ディスクリプタ
	 */
	virtual void SetFD(int nFD);

	/**
	 *	中身の状態を初期化する
	 *	(note)
	 *	このメソッドが呼ばれた場合内部のメンバ変数は全てクリアする処理を
	 *	記述してください。
	 */
	virtual void Initialize(void) {};

	/**
	 *	このアイテム自体がフォルダかどうか？
	 *	@return bool
	 *
	 */
	bool isFolder(void);

	/**
	 * このアイテム自体がシンボリックかどうか？（Unix用）
	 * @return bool
	 *
	 */
	bool isSymLink(void);

	/**
	 * このアイテムは一時アイテムかどうか？
	 * TeamFile的に一時かどうかです。ファイル属性ではない
	 *
	 */
	bool isTemporary(void);

	TF_FOLDER_TYPE GetFolderType(void);
	void  SetFolderType(TF_FOLDER_TYPE enuType);

#ifdef _DEBUG
	public:
		TF_STRING_A m_strClassName;
#endif

protected:
	int 		m_nFD;				//< ファイルディスクリプタ
	TFLIB_DECLARE_CLASS(CTFLocalFileItem)

protected:
	TF_SIZE_T	m_unSize;			//< ファイルサイズ（バイト）
	TF_SIZE_T	m_unAttr;			//< 属性
	TF_FOLDER_TYPE	m_enuFolderType;//< フォルダタイプ

	TF_STRING_A	m_strContentType;	//< コンテンツタイプ


};

TF_END_CLASSEXPORT

#endif
