/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *  $Id$
 *
 *	ファイル名	:	TFRFID.h
 *	クラス名	:	CTFRFID
 *	継承		:
 *
 *	機能　		:	アプリケーション側で利用しやすいようなID
 *					ResourceID(RID)を生成解析できるクラス
 *
 *	RIDのフォーマット
 *
 *	サーバID	：サーバ１
 *	URI			：/server/folder1/folder2/
 *
 *	TFRID[0]	サーバID					サーバ１
 *	TFRID[1]	アイテムの種類
 *	TFRID[2]	アイテムの種類（親）
 *	TFRID[3]	アイテムのURI 1番目		server
 *	TFRID[4]	アイテムのURI 2番目		folder1
 *	TFRID[5]	アイテムのURI 3番目		folder2
 *	.....		......						.....
 */
#ifndef	TF_LIB_TFRID_H
#define	TF_LIB_TFRID_H	1

#include "TFLibPublic.h"
#include "TFResourceItem.h"

TF_BEGIN_CLASSEXPORT
class TF_EXPORT CTFRID
{
public:
	CTFRID(void);
	~CTFRID(void);
	/**
	 *	DAVリソースに対するRIDを作成する
	 */
	void SetItem(CTFResourceItem* pItem);

	/**
	 *	RIDからサーバIDを抜き取る
	 */
	const TFXMLCh* GetServerID(void);

	/**
	 *	RIDからアイテムタイプを抜き取る
	 */
	TFITEMTYPE GetType(void);

	/**
	 *	RIDがフォルダかどうかを調べる
	 */
	bool IsFolder(void);

	/**
	 *	オペレータ( = )
	 */
	CTFRID& operator =(const CTFRID& source);

	/**
	 *	オペレータ( == )
	 */
	bool operator ==(const CTFRID& source);

private:
	/**
	 *	DAVリソースのアイテムからアイテムのタイプを取得する
	 */
	TFITEMTYPE getItemType(CTFResourceItem* pItem);

private:
/*
	#define TFRIDFMT_MIN_SIZE	3

	enum TFRIDFORMAT {
		TFRIDFMTSERVER	= 0,		//< サーバ名
		TFRIDFMTTYPE	= 1,		//< アイテムタイプ
		TFRIDFMTURI		= 2			//< URI
	};
*/
	TF_STRING_W			m_strURI;
	TF_STRING_W			m_strServerID;
	TFITEMTYPE			m_enuType;
};

TF_END_CLASSEXPORT
#endif

