#ifndef TF_LIB_TFREGEX_H
#define TF_LIB_TFREGEX_H	1
/**
 *	Copyrigth(c) 2007 COMPUTER HI-TECH TeamFile Team
 *  $Id$
 *
 *	ファイル名	:	TFRegex.h
 *	クラス名	:	CTFRegex
 *	継承		:
 *
 *	機能　		:	正規表現を取り扱うクラス
 *					Perl Compatible Regular Expressions(PCRE)を利用します。
 *
 */

#include "TFLibPublic.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#if defined(_WIN32) && defined(HAVE_LIBPCRE)
#include "pcre/pcre.h"
#else
#ifdef HAVE_LIBPCRE
#include "pcre.h"
#endif
#endif

TF_BEGIN_CLASSEXPORT
class TF_EXPORT CTFRegex
{
public:
	CTFRegex(void);
	~CTFRegex(void);

	/*
	 *	PCREをサポートしている場合trueを返す
	 */
	bool IsSupported(void);
	
	/**
	 *	パターンを追加する
	 *	@param pattern	const char*
	 *	@param nOptions	int
	 *
	 *	@param int			0: 正常 / 0 < 失敗
	 */
	int AddPattern(const char* pattern, int nOptions);
	
	/**
	 *	登録したパターンでチェックを行なう
	 *	@param const char* pszData
	 *
	 *	@return int	(見つかったパターンのID）
	 */
	int Search(const char* pszData);
	
protected:
#ifdef HAVE_LIBPCRE
	std::vector<pcre*>	m_vPCRE;
#endif
};
TF_END_CLASSEXPORT

#endif
