/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *  $Id$
 *
 *	ファイル名	:	TFResorceItem.h
 *	クラス名	:	CTFResorceItem
 *	継承		:	CTFObject
 *
 *	機能　		:	DAVのリソースを内部にもつアプリ側に必要な情報を
 *					保有するアイテム
 *					リソースには必ず名前があるが、空白の場合は問題のある
 *					アイテムである。基本的に扱ってはいけません。
 *
 */
#ifndef	TF_LIB_TFRESORCEITEM_H
#define TF_LIB_TFRESORCEITEM_H	1

#include "TFLibPublic.h"
#include "TFObject.h"
#include <time.h>

TF_BEGIN_CLASSEXPORT

class TF_EXPORT CTFResourceItem : public CTFObject
{
public:
	CTFResourceItem(void);
	virtual ~CTFResourceItem(void);
	virtual void Import(const CTFObject& source);

	// Name
	const TFXMLCh* GetName(void);
	void SetName(const TFXMLCh* strName);

	TFITEMTYPE GetType(void);

	// Server ID (Name)
	const TFXMLCh* GetServerID(void);
	void SetServerID(const TFXMLCh* strServerID);
	bool IsServerID(const TFXMLCh* strServerID);
	time_t	GetItemCreateTime(void);

	// Root URI
	const TFXMLCh* GetRootURI(void);
	// Root URL
	const TFXMLCh* GetROOTURL(void);

	bool operator ==(const CTFResourceItem& source);

	TFLIB_DECLARE_CLASS(CTFResourceItem)
	static CTFClassInfo m_cClass2CTFResourceItem;

protected:

	TF_STRING_W		m_strName;			//< アイテム名
	TF_STRING_W		m_strServerID;		//< サーバID
	TFITEMTYPE		m_enuType;			//< アイテムタイプ
	time_t		m_tCreateTime;			///< このオブジェクトが作成された時間
};

TF_END_CLASSEXPORT

#endif

