/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *  $Id$
 *
 *	ファイル名	:	TFLibResourceProp.h
 *	クラス名	:	CTFLibResourceProp
 *	継承		:	CTFLibDavResource
 *
 *	機能　		:	DAV LIVEPropertyを管理する
 *
 *
 */
#ifndef TF_LIB_RESOURCEPROP_H
#define TF_LIB_RESOURCEPROP_H 1

#include "TFDavResource.h"
#include "TFLibDefinition.h"
#include "oimap.h"


TF_BEGIN_CLASSEXPORT

class TF_EXPORT CTFResourceProp : public CTFDavResource
{

friend class CTFXmlBodyPaser;

public:
	CTFResourceProp(void);
	virtual ~CTFResourceProp(void);
	virtual void Import(const CTFObject& source);

	void SetCreationDate(time_t time);
	void SetDisplayName(const TFXMLCh* pszName);
	void SetContentLanguage(const TFXMLCh* pszLang);
	void SetContentLength(TF_SIZE_T len);
	void SetContentType(const TFXMLCh* strType);
	void SetEtag(const TFXMLCh* pszEtag);
	void SetLastModified(time_t time);
	void SetResourceType(OI_RES_TYPE enuType);
	void SetLock(CDavLock *cLock);

	time_t GetCreationDate(void);
	const TFXMLCh* GetDisplayName(void);
	const TFXMLCh* GetContentLanguage(void);
	TF_SIZE_T GetContentLength(void);
	const TFXMLCh* GetContentType(void);
	const TFXMLCh* GetEtag(void);
	time_t GetLastModified(void);
	OI_RES_TYPE GetResourceType(void);
	bool	IsCollection(void);
	bool	IsNullResource(void);
	LOCKLIST GetLocklist(void);
	
protected:
	// RFC 2518 LIVE Property
	time_t			m_tCreationDate;		///< creationdate
	TF_STRING_W		m_strDisplayName;		///< Displayname
	TF_STRING_W		m_strContentLanguage;	///< getcontentlanguage
	TF_SIZE_T		m_iContentLength;		///< getcontentlength
	TF_STRING_W		m_strContentType;		///< getcontenttype
	TF_STRING_W		m_strEtag;				///< getetag
	time_t			m_tLastmodified;		///< getlastmodified
	OI_RES_TYPE		m_enuResourceType;		///< resourcetype
	LOCKLIST		m_vecLocklist;			///< lock

	TFLIB_DECLARE_CLASS(CTFResourceProp)
private:
	bool			m_bNullResource;		///< NULLリソース
};

TF_END_CLASSEXPORT

#endif

