/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *	$Id$
 *
 *	ファイル名	:   TFResourceProTFp.h
 *	クラス名	    :   CTFResourcePropTF
 *	継承		    :
 *
 *	機能			:   TeamFile独自のPropetyを管理する
 *
 *
 */
#ifndef TF_LIB_TFRESORCEPROPTF_H
#define TF_LIB_TFRESORCEPROPTF_H 1

#include "TFResourceProp.h"
#include "TFLibDefinition.h"

TF_BEGIN_CLASSEXPORT

class TF_EXPORT CTFResourcePropTF :
	public CTFResourceProp
{
public:
	CTFResourcePropTF(void);
	virtual ~CTFResourcePropTF(void);
	virtual void Import(const CTFObject& source);

	void SetCreator(const TFXMLCh* pszCreator);
	void SetLastModifire(const TFXMLCh* pszModifire);
	void SetMailWatchMethod(const TFXMLCh* pszMethod);
	void SetMailWatchOwner(bool bOwner=false);
	void SetDeleter(const TFXMLCh* pszDeleter);
	void SetDeletion(time_t pszDeletion);
	void SetResourceState(TFRESOURCESTATE nResState);
	void SetUserPrivilegeGrantSet(TFUSERPRIV nPriv);
	
	const TFXMLCh* GetCreator(void);
	const TFXMLCh* GetLastModifire(void);
	int GetMailWatchMethod(void);
	bool IsMailWatch(void);
	bool IsMailWatchOwner(void);
	const TFXMLCh* GetDeleter(void);
	time_t GetDeletion(void);
	TFRESOURCESTATE	GetResourceState(void);
	TFUSERPRIV GetUserPrivilegeGrantSet(void);
	
protected:
	// teamfile 拡張プロパティ
	TF_STRING_W		m_strCreator;			///< creator
	TF_STRING_W		m_strLastModifire;		///< lastmodifire
	int				m_iMailWatchMethod;		///< メール監視されているメソッド
	bool			m_bMailWatchOwner;		///< 自分がメールウォッチオーナー

	// teamfile拡張（ごみ箱フォルダ関係）
	TF_STRING_W		m_strDeleter;			///< 削除者
	time_t			m_tDeletion;			///< 削除日

	// 拡張
	TFRESOURCESTATE	m_nResState;			///< リソース状態
	TFUSERPRIV		m_nUserPrivilege;		///< オペレーション権限
	
	TFLIB_DECLARE_CLASS(CTFResourcePropTF)
};
TF_END_CLASSEXPORT

// typedef
typedef CTFResourcePropTF*		PTFRESOURCE;
typedef std::list<PTFRESOURCE>	LPTFRESOURCE;

#endif

