/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *  $Id$
 *
 *	ファイル名	:	TFResourcePropTFUser.h
 *	クラス名	:	CTFResourcePropTFUser
 *	継承		:
 *
 *	機能　		:	ユーザリソース
 *
 *
 */
#ifndef TF_LIB_RESOURCEPROPTFUSER_H
#define TF_LIB_RESOURCEPROPTFUSER_H	1

#include "TFResourceProp.h"

TF_BEGIN_CLASSEXPORT

class TF_EXPORT CTFResourcePropTFUser :
	public CTFResourceProp
{
public:
	CTFResourcePropTFUser(void);
	virtual ~CTFResourcePropTFUser(void);
	virtual void Import(const CTFObject& source);

	void SetUID(const TFXMLCh* pszUserID);
	void SetPassWord(const TFXMLCh* pszPassWord);
	void SetStorages(const TFXMLCh* strSize, TF_STAT_QUOTA_TYPE enuType);
	void SetResources(const TFXMLCh* strCnt, TF_STAT_QUOTA_TYPE enuType);
	void SetLastAccessClient(const TFXMLCh* pszClient);
	void SetMailAddr(const TFXMLCh* pszAddress);
	void SetAdminFlag(bool bAdmin);
	void SetComment(const TFXMLCh* strComment);
	void SetAccessDeny(const TFXMLCh* strAccessDeny);
	void SetLastAccessDate(time_t time);
	void SetExpiration(time_t time);
	void SetStatus(TFUSERSTATUS nStatus);
	void SetPrivilege(TFUSERPRIV nPriv);
	void SetUserType(const TFXMLCh* pszUserType);
	void SetUserType(TF_USER_TYPE enuType);

	// 最大作成ユーザ数
	void SetMaxuserCreation(const TFXMLCh* strSize);
	TF_SIZE_T GetMaxuserCreation(void);
	const TFXMLCh* GetMaxuserCreationString(void);

	// オーナー名 / オーナーID
	void SetOwnerName(const TFXMLCh* strName);
	void SetOwnerID(const TFXMLCh* strID);
	const TFXMLCh* GetOwnerName(void);
	const TFXMLCh* GetOwnerID(void);

	// ID
	const TFXMLCh* GetUID(void);

	// パスワード
	const TFXMLCh* GetPassWord(void);

	// ストレージ容量
	TF_SIZE_T		GetStorages(TF_STAT_QUOTA_TYPE enuType);
	const TFXMLCh*	GetStoragesString(TF_STAT_QUOTA_TYPE enuType);

	// リソース数
	TF_SIZE_T		GetResources(TF_STAT_QUOTA_TYPE enuType);
	const TFXMLCh*	GetResourcesString(TF_STAT_QUOTA_TYPE enuType);

	const TFXMLCh* GetLastAccessClient(void);
	const TFXMLCh* GetMailAddr(void);
	bool GetAdminFlag(void);
	const TFXMLCh* GetComment(void);
	const TFXMLCh* GetAccessDeny(void);
	time_t	GetLastAccessDate(void);
	time_t	GetExpiration(void);
	TFUSERSTATUS GetStatus(void);
	TFUSERPRIV GetPrivilege(void);
	TF_USER_TYPE GetUserType(void);
	const char* GetUserTypeString(void);

	// 他人ユーザ
	void SetOtherUser(bool bIsOther);
	bool GetIsOtherUser(void);

private:
	TF_STRING_W		m_strUserID;				//< ユーザID
//	TF_STRING_W		m_strUserName;			//< ユーザ名 TFResourceItemのName()に任せる
	TF_STRING_W		m_strUsedStorage;			//< 利用ストレージ容量
	TF_STRING_W		m_strMaxStorage;			//< 最大ストレージ容量
	TF_STRING_W		m_strUsedResources;			//< 使用リソース数
	TF_STRING_W		m_strMaxResources;			//< 最大リソース数
	TF_STRING_W		m_strPassWord;				//< ユーザパスワード
	TF_STRING_W		m_strLastAccessedClient;	//< 最終アクセスクライアント(USERAGENT)
	bool			m_bAdmin;					//< 管理者の場合TRUE
	TF_STRING_W		m_strMailAddress;			//< メールアドレス
	TF_STRING_W		m_strComment;				//< コメント
	TF_STRING_W		m_strAccessDeny;			//< アクセス禁止場所
	time_t			m_tLastAccesseDate;			//< 最終アクセス日
	time_t			m_tExpiration;				//< 有効期限
	TFUSERSTATUS	m_nState;					//< ステータス
	TFUSERPRIV		m_nPriv;					//< ユーザ権限
	TF_USER_TYPE	m_enuUserType;				//< ユーザタイプ
	TF_STRING_W		m_strMaxuserCreation;		//< 最大作成ユーザ数
	TF_STRING_W		m_strOwnerName;				//< オーナー名
	TF_STRING_W		m_strOwnerID;				//< オーナーID
	bool			m_bOtheruser;				//< 検索したユーザからみて他人か？

private:
	TF_SIZE_T		m_i64tmp;

protected:
	TFLIB_DECLARE_CLASS(CTFResourcePropTFUser)

};

TF_END_CLASSEXPORT

#endif

