#ifndef TFLIB_TFSSLCERTIFICATE_H
#define TFLIB_TFSSLCERTIFICATE_H 1

#include "TFLibPublic.h"

TF_BEGIN_CLASSEXPORT

class TF_EXPORT CTFSSLCertificate
{
public:
	CTFSSLCertificate(void);
	~CTFSSLCertificate(void);

	/**
	 *	証明書を登録する
	 *	@param    pCerts     void*
	 *	@return   1: 成功 / 0:失敗
	 *	(note)
	 *	引数のvoidにはOnionのCDavSSLCertificateList*を渡してください。
	 */
	int SetCerts(void *pCerts);

	/**
	 *	証明書の数をチェックする
	 *	@param    void
	 *	@return   int
	 */
	unsigned int GetCertCount(void);

	/**
	 *	証明書を取得する
	 *	@param    nIndex      unsigned int  インデックス
	 *	@param    pData       void**        データ実体
	 *  @param    nDataLength unsigned int  ｐDataのデータ長
	 *
	 *	@return   1: 成功 / 0: 失敗もしくは無し
	 */
	int GetCertData(unsigned int nIndex, void** pData, unsigned int* nDataLength);

	/**
	 *	保持している証明書を返す
	 *	@param     void
	 *	@return    void*
	 *	(note)
	 *	戻りはCDavSSLCertificateList*です。キャストして利用してください。
	 *	NULLの場合もありますのでNULLチェックを行うこと。
	 */
	void* GetCerts(void);

	/**
	 *	登録されている証明書をクリアする
	 *	@param    void
	 *	@return   void
	 */
	void Clear(void);

	/**
	 *	onionライブラリにSSLの証明書を登録する。最終的に内部で
	 *	OpenSSLにストアします。
	 *	@param    void
	 *	@return   int         登録された件数
	 */
	int SetCertificatesOnion(void);

private:
	void*       m_pSSLCert;
};

TF_END_CLASSEXPORT

#endif
