/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *  $Id$
 *
 *	ファイル名		:	TFServerManager.h
 *	クラス名		:	CTFServerManager
 *	継承			:
 *
 *	機能　		:	サーバアイテムを管理するクラス
 *					サーバ一覧を作成したり列挙したりDAVのリソースからサーバ情報を
 *					抜き取ることができます。
 *
 *					(note)
 *					このメソッドの実行は必ずCTFCriticalSectionLockerでロックを行なって
 *					実装を行なうこと
 */
#ifndef TF_LIB_SERVERMANAGER_H
#define TF_LIB_SERVERMANAGER_H 1

#include "TFServerResource.h"
#include "TFDavResourceList.h"
#include "TFXMLServerSettings.h"
#include "TFWsSystemInformationHandler.h"
#include "TFCriticalSectionLocker.h"
#include "TFServerResource.h"
#include "TFSSLCertificate.h"

TF_BEGIN_CLASSEXPORT

class TF_EXPORT CTFServerManager
{
private:
	/*
	 *	SSLの証明書をチェックされたかを調べる列挙型
	 */
	enum TFSSLSYSSTORE {
		TF_STORE_NONE = 0,
		TF_STORE_TRUE,
		TF_STORE_FALSE
	};

public:
	CTFServerManager(void);
	~CTFServerManager(void);

	void Initialize(void);
	void Terminate(void);

	void AddHandler(CTFWsSystemInformationHandler *pHandler);
	CTFWsSystemInformationHandler* GetSysHandler(void);

	// サーバアイテム（取得）
	CTFServerResource* GetServerItem(const TFXMLCh* pszServerID);
	CTFServerResource* GetServerItem(int nIndex);

	CTFDavResourceList* GetServerItemList(void);

	bool AddServerItem(CTFServerResource* pSvrItem);

	// SSL関係
public:
	void RemoveCertStore(void);
	void SaveSystemServerCert(CTFSSLCertificate* pCert);

private:
	void createServerList(void);
	void loadSystemCerts(void);


private:
	static CTFDavResourceList*				gs_pSvrItemList;
	static CTFWsSystemInformationHandler*	gs_pSystemHandler;
	static CTFWsSystemInformationHandler	gs_cSystemHandler;
	static CTFCriticalSection				gs_SMCritSect;
	static CTFSSLCertificate*               gs_pSSLCert;
	static TFSSLSYSSTORE					gs_enuSSLStore;

};


TF_END_CLASSEXPORT

TF_EXPORT CTFServerManager& GetServerManager();

#endif


