/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *  $Id$
 *
 *	ファイル名	:	TFServerResource.h
 *	クラス名	:	CTFServerResource
 *	継承		:	CTFDavResource
 *
 *	機能　		:	サーバ情報やユーザ情報を保持するDAVリソースアイテム
 *
 *
 */
#ifndef TF_LIB_SERVERRESOURCE_H
#define TF_LIB_SERVERRESOURCE_H 1

#include "TFDavResource.h"
#include "TFLibDefinition.h"

class CTFSSLCertificate;

TF_BEGIN_CLASSEXPORT

class TF_EXPORT CTFServerResource :
	public CTFDavResource
{
public:
	CTFServerResource(void);
	virtual ~CTFServerResource(void);
	
	virtual void Import(const CTFObject& source);

	bool IsValid(void);

	const TFXMLCh* GetUserID(void);
	const TFXMLCh* GetPassWord(void);
	const TFXMLCh* GetHost(void);
	int GetPort(void);
	const TFXMLCh* GetProxyHost(void);
	int GetProxyPort(void);
	const TFXMLCh* GetProxyUserID(void);
	const TFXMLCh* GetProxyPassWord(void);
	bool GetOmitLockFlag(void);
	bool GetUseSSL(void);
	unsigned int GetSocketTimeout(void);
	bool GetUseCompression(void);
	CTFSSLCertificate* GetSSLCertificate(void);

	void SetUserID(const TFXMLCh* pszUserID);
	void SetPassWord(const TFXMLCh* pszPassWord);
	void SetHost(const TFXMLCh* pszHost);
	void SetPort(int nPort);
	void SetProxyHost(const TFXMLCh* pProxyHost);
	void SetProxyPort(int nPort);
	void SetProxyUserID(const TFXMLCh* pProxyUserID);
	void SetProxyPassWord(const TFXMLCh* pProxyPassWord);
	void SetUserAgent(const TFXMLCh* pszUserAgent);
	void SetOmitLockFlag(bool bOmit);
	void SetUseSSL(bool bUseSSL);
	void SetSocketTimeout(unsigned int unTimeout);		// 秒単位
	void SetUseCompression(bool bComplress);

	void SetSSLCertificate(CTFSSLCertificate* pCert);
	TFLIB_DECLARE_CLASS(CTFServerResource)

protected:

	// SSL
	CTFSSLCertificate*   m_pSSLCert;		//< SSL証明書

	// ユーザ情報
	TF_STRING_W	m_strUserID;				//< ユーザID
	TF_STRING_W	m_strPassWord;				//< パスワード

	// ホスト情報
	TF_STRING_W	m_strHost;					//< ホスト名
	int			m_nHostPort;				//< ポート

	// Proxy情報
	TF_STRING_W	m_strProxyHost;				//< プロキシホスト名
	int			m_nProxyHostPort;			//< プロキシポート番号
	TF_STRING_W	m_strProxyUserID;			//< プロキシユーザ名
	TF_STRING_W	m_strProxyUserPassWord;		//< プロキシパスワード

	// クライアント属性
	bool		m_bSkipLock;				//< ロック処理の可否

	// SSL関係
	bool		m_bUseSSL;					//< SSLの利用

	// socket関係
	unsigned int m_unSocketTimeout;

	// 圧縮要求
	bool		m_bUseCompression;			//< 圧縮要求

};

TF_END_CLASSEXPORT

#endif		// TF_LIB_SERVERRESOURCE_H

