/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *  $Id$
 *
 *	ファイル名	:	TFTransaction.h
 *	クラス名	:	TFTransaction
 *	継承		:	CTFLibTransaction
 *
 *	機能　		:	DAVに関するシーケンスのすべてが実装されるためのクラス
 *					
 *
 *
 */
#ifndef	TF_LIB_TRANSACTION_H
#define	TF_LIB_TRANSACTION_H	1

#include "TFLibTransactionBase.h"
#include "TFResourceItem.h"
#include "TFWsTransactionHandler.h"

class CTFResourcePropTFUser;
class CTFResourcePropTFGroup;

TF_BEGIN_CLASSEXPORT
class TF_EXPORT CTFTransaction :
	public CTFLibTransactionBase
{
public:
	CTFTransaction(void);
	~CTFTransaction(void);

	/**
	 *	トランザクションを繰り返して使いたい場合に利用する
	 *	StartTrans()とEndTrans()はセットで利用する事。
	 */
	void StartTrans(const TFXMLCh* pszServerID);
	void EndTrans(void);
	
	// DAV METHOD

	// PROPFIND
	bool List(CTFResourceItem* pItem, CTFResourceProp** ppItem, bool bRecursive=false);

	/**
	 *	一つのDAVアイテムを指定した(pLocalItem)へダウンロードする
	 *	@param	pItem		CTFResourceItem*		ダウンロードアイテム
	 */
	bool Download(CTFResourceItem* pItem, bool bRecursive=true);

	/**
	 *	対象リソースを取得する
	 *	
	 *	@param	pszServerID		const TFXMLCh*				サーバID
	 *	@param	lpResource		CTFResourceItemList*		取得対象リソース
	 *	@param	bRecursive		bool						再帰取得
	 *
	 *	@return boolean
	 */
	bool Download(const TFXMLCh* pszServerID,  CTFResourceItemList* ppItem, bool bRecursive);

	// PUT
	bool Upload(const TFXMLCh* pszServerID,
				CTFResourceItem* ppItem,
				TF_STRVECTOR_W vFiles);

	bool MakeNewResource(const TFXMLCh* pszServerID);

	// DELETE
	bool Delete(CTFResourceItem* ppItem, CTFResourceItem* pItem=NULL, bool bforce=false);

	/**
	 *	対象リソースを削除する
	 *
	 *	@param	pszServerID		const TFXMLCh*		サーバID
	 *	@param	ppItem				CTFResourceItem*		削除対象親リソース
	 *	@param	pItem				CTFResourceItem*		削除対象アイテム
	 *
	 *	@return boolean
	 * (note)
	 *	サーバIDは必須項目。削除対象の親リソースだけを指定した場合はハンドラ
	 *	で削除対象アイテムを問い合わせてきます。
	 *	削除対象親リソースがNULLの場合は削除対象アイテムのみの削除を行ないます。
	 */
	bool Delete(const TFXMLCh* pszServerID,
				CTFResourceItem* ppItem=NULL,
				CTFResourceItem* pItem=NULL);

	// LOCK
	bool Lock(CTFResourceItem* ppItem);
	bool Unlock();

	// COPY
	bool Copy(CTFResourceItem* ppItem);
	bool SetAvailableUser(const TFXMLCh* pszServerID, CTFResourceItemList* pGrpList, CTFResourceItemList* pItemList=NULL);

	// MKCOL
	bool MakeFolder(CTFResourceItem* pParentItem);
	bool MakeCol(const TFXMLCh* pszServerID, const TFXMLCh* pszParentURI, const TFXMLCh* pszName);
	bool MakeColEx(CTFResourceItem* ppItem, TFXMLBODYTYPE enuType, CTFResourceItem* pItem=NULL);

	// MOVE
	/**
	 *	Move Resource
	 *
	 *	@param pszSrcServerID	const TFXMLCh*
	 *	@param	pszDstServerID	const TFXMLCh*
	 *	@param	pszDstUri			const TFXMLCh*
	 *	@param	pItemList			CTFResourceItemList*
	 *
	 *	(note)
	 *	pItemList=NULLの場合はハンドラで移動させたいアイテムを問い合わせてきます。
	 *
	 */
	bool MoveResource(const TFXMLCh* pszSrcServerID,
					  const TFXMLCh* pszDestUri,
					  const TFXMLCh* pszDstServerID=NULL,
					  CTFResourceItemList* pItemList=NULL);

	/**
	 *	ReName Resource
	 *
	 *	@param	pszServerID		const	TFXMLCh*
	 *	@param	pszOldUri			const	TFXMLCh*
	 *	@param pszNewUri			const	TFXMLCh*
	 *
	 *	(note)
	 */
	bool ReName(const TFXMLCh* pszServerID,
				const TFXMLCh* pszOldUri,
				const TFXMLCh* pszNewUri);

	bool ReName(CTFResourceItem* pItem);		// MOVE(RENAME動作）

	// PROPPATCH
	bool PatchProperty(const TFXMLCh* pszServerID, const TFXMLCh* pszParentURI, TFXMLBODYTYPE enuType, CTFResourceItem* pItem);

	// SEARCH METHOD
	bool SearchRootTree(CTFResourceItem* pItem, CTFResourceProp** ppItem, TFSEARCH_RT enuType);
	bool SearchStatus(CTFResourceItem* pItem, CTFResourceProp** ppItem);

	/**
	 *	user information search
	 *
	 *	@param	pszServerID		const TFXMLCh*
	 *	@param	pUsrItem		CTFResourcePropTFUser*
	 *	@param	ppItem			CTFresourceProp**
	 *	@param	enuType			TF_SEARCH_UI
	 *
	 *	@return boolean
	 */
	bool SearchUser(const TFXMLCh* pszServerID,
				    CTFResourcePropTFUser* pUsrItem,
				    CTFResourceProp** ppItem,
				    TF_SEARCH_UI enuType);

	/**
	 *	system information search
	 *
	 *	@param		pszServerID		const TFXMLCh*
	 *	@param		ppItem				CTFResourceProp**
	 *	@param		enuType			TF_SEARCH_SMI
	 *	@param		pszMsgID			const TFXMLCh*
	 *
	 *	@return	boolean
	 */
	bool SearchSysMsg(const TFXMLCh*	pszServerID,
					  CTFResourceProp** ppItem,
					  TF_SEARCH_SMI		enuType = TF_SEARCH_SMI_NONE,
					  const TFXMLCh*	pszMsgID = NULL);

	bool SearchUpdate(CTFResourceItem* pItem, CTFResourceProp** ppItem);
	bool SearchDBMS(CTFResourceItem* pItem, CTFResourceProp** ppItem, TF_SEARCH_DI enuType=TF_SEARCH_DI_NONE, const char* pszDBMSID=NULL);

	/**
	 * group information search
	 *
	 *	@param pszServerID		const TFXMLCh*
	 *	@param pGrpItem			CTFResourcePropTFGroup*
	 *	@param ppItem				CTFResourceProp**
	 *	@param enuType			TF_SEARCH_GI
	 *
	 *	@return boolean
	 */
	bool SearchGroup(const TFXMLCh* pszServerID,
					 CTFResourcePropTFGroup* pGrpItem,
					 CTFResourceProp** ppItem,
					 TF_SEARCH_GI enuType);

	/**
	 * セッションの維持状態を変更する
	 *
	 * @param	bKeep		bool	( true: 維持 / false: 破棄 )
	 *
	 * @return	void
	 *
	 */
	void SetKeepSession(bool bKeep);

public:
	bool m_bSeqParentchk;			// シーケンスで親のフォルダを調べるか？(default:true)

private:
	CTFLibWorkSessionWorker*	m_pWsTransWorker;
	bool						m_bConPending;
};

TF_END_CLASSEXPORT
#endif

