
#include "TFLibDefinition.h"

#ifndef TF_LIB_TFURL_H
#define TF_LIB_TFURL_H	1

TF_BEGIN_CLASSEXPORT

class TF_EXPORT CTFURL
{
public:
	CTFURL(void);
	CTFURL(const TFXMLCh* pszURL);
	~CTFURL(void);
	bool parseURL(const TFXMLCh* pszURL);
	bool BuildURL(bool bWithProtocol, bool bWithURI);

	bool IsHTTP(void);
	bool IsHTTPS(void);

	TF_STRING_W		m_strURL;			//< URL
	TF_STRING_W		m_strProtocol;		//< PROTCOL
	TF_STRING_W		m_strHost;			//< HOST
	int				m_nPort;			//< PORT
	TF_STRING_W		m_strDir;			//< DIRECTORY
	TF_STRING_W		m_strName;			//< Name
	TF_STRING_W		m_strURI;			//< URI
	bool			m_bFolder;			//< Folderか？
	TF_STRING_W		m_strNamePrefix;	//< 名前のプレフィックス
	TF_STRING_W		m_strNameSuffix;	//< 名前のサフィックス

protected:
	bool parseHostnameAndPortNumber(const TFXMLCh* pszHostPort, TF_STRING_W &strHostName, int &nPort);
	bool parseDirAndName(const TFXMLCh* pszURI, TF_STRING_W &strDir, TF_STRING_W& strName, bool& bFolder);

private:
	void initialize();
};

TF_END_CLASSEXPORT

#endif

