#ifndef TF_LIB_TFUTILS_H
#define TF_LIB_TFUTILS_H	1

#include "TFLibPublic.h"

TF_BEGIN_CLASSEXPORT

/**
 *	ライブラリの起動に必要なクラスのロードを行ないます。
 */
extern TF_EXPORT void TFInitialize(void);

/**
 *	ライブラリの終了処理を行ないます。
 */
extern TF_EXPORT void TFTerminate(void);

extern TF_EXPORT bool FormatTimeISO8601(TF_STRING_A& str, const time_t gmt);
extern TF_EXPORT bool FormatTimeJapan(TF_STRING_A& str, const time_t t);

extern TF_EXPORT int ParseMailWatchString(const char* pszMethod);
extern TF_EXPORT void BuildMailWatch(int nMethods, TF_STRING_W& strString);
extern TF_EXPORT void BuildAccessZone(int nZone, TF_STRING_W& strString);
extern TF_EXPORT bool GetFinalPathSegment(const TFXMLCh* pszURI, TF_STRING_W& strName);
extern TF_EXPORT void TFDebugPrint(const char* pszFormat, ...);
extern TF_EXPORT void GetToday(TF_STRING_A& strDate);
extern TF_EXPORT time_t ParseTimeJapan(const char* pszTime);
extern TF_EXPORT void RemoveSlash(TF_STRING_W& strURI);
extern TF_EXPORT void RemoveDoubleSlashA(TF_STRING_A& strPath);
extern TF_EXPORT void RemoveDoubleSlashW(TF_STRING_W& strPath);


TF_END_CLASSEXPORT

#endif
