#ifndef	TF_LIB_BROSERHANDLER_H
#define TF_LIB_BROSERHANDLER_H	1

#include "TFResourceItem.h"
#include "TFRID.h"

TF_BEGIN_CLASSEXPORT
class TF_EXPORT CTFWsBrowserHandler
{

friend class CTFBroadCaster;

public:
	CTFWsBrowserHandler(void);
	virtual ~CTFWsBrowserHandler(void);

	/**
	 *	リソースが更新などされた場合に呼び出されるハンドラ
	 *	TFNOTIFYTYPEで処理を分けて実装してください。
	 *	@param		TFRID				vParentID		親フォルダ
	 *	@param		CTFResourceItem	pItem			リソースアイテム
	 *	@return	void
	 */
	virtual void OnUpdateResource(TFRID vParentID, TFNOTIFYTYPE enuType,  CTFResourceItem* pItem);

private:
	unsigned int m_unID;
};
TF_END_CLASSEXPORT
#endif

