/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *  $Id$
 *
 *	ファイル名	:	TFWsNotificationHandler.h
 *	クラス名	:	CTFWsNotificationHandler
 *	継承		:
 *
 *	機能　		:	ライブラリなどで必要な警告などを表示する
 *					ダイアログのハンドラクラス
 *					利用する為には、すべてのvirtual関数を実装しなければいけません。
 *
 *
 */

#ifndef	TF_LIB_CTFWSNOTIFICATIONHANDLER_H
#define	TF_LIB_CTFWSNOTIFICATIONHANDLER_H	1

#include "TFLibPublic.h"


class CTFResourceItemList;
class CTFSSLCertificate;

TF_BEGIN_CLASSEXPORT
class TF_EXPORT CTFWsNotificationHandler
{
public:
	CTFWsNotificationHandler(void);
	virtual ~CTFWsNotificationHandler(void);

	/**
	 *	認証が行なわれる際に呼び出されるハンドラ
	 */
	virtual	bool OnAuthenticateNotify(const char* pszRealm, TF_STRING_A& strUsername,
							TF_STRING_A& strPasswd, int nRetry, TF_AUTH_CLASS enuAuthClass);

	/**
	 *	認証の回数をチェックするためのハンドラ
	 */
	virtual bool OnQueryAuthRetryCount(int nRetry, TF_AUTH_CLASS enuAuthClass);

	/**
	 * エラーメッセージに応じて画面等を設定依頼してくるハンドラです。
	 */
	virtual TFDLGNOTIFYTYPE OnNotifyMessage(TFRESULT enuResult, int nNotifyType, CTFResourceItemList* pItemList=NULL);

	/**
	 *	プログレスのウィンドウを表示などして欲しい場合に呼ばれるハンドラです。
	 *	必ずオペレーションを行うときに呼ばれてくるハンドラ。
	 *	必須ではないのでfalseを返した場合は以降のOnUpdateProgressWindow()は呼ばれません。
	 *	@param	hHandle	TFHANDLE	ハンドル
	 *	@param	enuMode モード
	 *
	 *	handleには作成したwindowの識別子などをいれて返してください。
	 *	handle自体はライブラリは意識しません。OnUpdateProgressWindow()
	 *	やOnTerminateProgressWindow()で渡すだけしかしません。
	 *
	 *	#### TODO この文はまだ途中です
	 */
	virtual bool OnInitializeProgressWindow(TFHANDLE *hHandle, TFTRANSMODE enuMode);

	/**
	 *	処理が開始される前に一度だけ呼ばれるメッセージハンドラです。
	 *	まだこの時点では処理（OnUpdateProgress)は呼ばれていません。
	 *	処理を開始する前になにかメッセージを出力したい場合に利用してください。
	 */
	virtual bool OnPreSendProgressWindow(const TFXMLCh* str, TFHANDLE hHandle);

	/**
	 *	プログレスのウィンドウを更新する為に呼ばれるハンドラです。
	 */
	virtual bool OnUpdateProgressWindow(const TFXMLCh* str, TFHANDLE hHandle, TF_SIZE_T unProgress, TF_SIZE_T unTotal);

	/**
	 *	プログレスのウィンドウの終了処理のときに呼ばれるハンドラです。
	 *
	 */
	virtual bool OnTerminateProgressWindow(TFHANDLE hHandle);

	/**
	 *	サーバがどのような種別なのかを返してくるハンドラ
	 *	@param	nAllowMethods		const int
	 *	@param	nAllowDASL			const int
	 *	リクエストをだしたサーバがどのようなメソッドなどをサポートしているかを
	 *	返してきます。
	 *	必要ならば内容に応じてダイアログを表示してください。
	 */
	virtual void OnResultServerType(const int nAllowMethods, const int nAllowDASL);

	/**
	 *	現在登録されているSSL証明書の一覧を返します。
	 *	@param	pCerts	CDavSSLCertificateList*
	 *	@return boolean
	 *	(note)
	 *	TODO: ポインタを渡しているので参照先がなくなる可能性があります。
	 *	一覧を表示するだけであれば戻値をtrueにしてください。
	 *	表示して尚且つ問題である場合はfalseを返してください。
	 */
	virtual bool OnNotifySSLCerts(CTFSSLCertificate* pCert) const;

};

TF_END_CLASSEXPORT

#endif

