#ifndef TF_LIB_TFWSSYSTEMINFORMATIONHANDLER_H
#define	TF_LIB_TFWSSYSTEMINFORMATIONHANDLER_H	1

#include "TFResourceItemList.h"
#include "TFLocalFileItem.h"

class CTFObject;
class CTFSSLCertificate;

TF_BEGIN_CLASSEXPORT

class TF_EXPORT CTFWsSystemInformationHandler
{
public:
	CTFWsSystemInformationHandler(void);
	virtual ~CTFWsSystemInformationHandler(void);

	/**
	 *	SSL証明書をシステムがもっているかを問い合わせてくるハンドラ
	 *	@return boolean
	 *
	 *	(note)
	 *	証明書をシステムで持っている場合はtrueを返してください。
	 *	あとから、証明書をストアするハンドラOnOpenSystemStore()が呼ばれてきます。
	 */
	virtual void OnQueryHasSSLCertificate(TF_SSL_CERT_HANDLE_TYPE& enuHandle);

	/**
	 *	システムで利用するユーザエージェントを設定できるハンドラ
	 */
	virtual void OnRequestUserAgentName(TF_STRING_A& strUserAgent);

	/**
	 *	システムからSSLの証明書ストアを開く
	 *	@param	pHandle		TFHANDLE
	 *	@param	strStoreName	const char*	開くストア名
	 *	@return boolean
	 *
	 */
	virtual bool OnOpenSystemStore(TF_SSL_CERT_STORE_NAME enuStoreName, TFHANDLE pHandle);

	/**
	 *	システムのSSL証明書をライブラリに渡す
	 *	@param     pHandle      TFHANDLE
	 *	@param     pSSLCert     CDavSSLCertificateList**
	 *	(note)
	 *	ここでpSSLCertに設定された証明書をライブラリが保持するようになります。
	 *
	 */
	virtual bool OnLoadCertsStore(TFHANDLE pHandle, CTFSSLCertificate** pSSLCert);

	/**
	 *	システムにSSL証明書を登録する
	 *	@param	pHandle			TFHANDLE
	 *	@param	pData			void*
	 *	@param	unLength		unsigned int
	 *	@return boolean
	 */
	virtual bool OnSaveCertStore(TFHANDLE pHandle, void *pData, unsigned int unLength);

	/**
	 *	システムのSSL証明書の終了処理を行なう
	 *
	 *	@param	pHandle	TFHANDLE
	 *	@return boolean
	 */
	virtual bool OnCloseCertsStore(TFHANDLE pHandle);

	/**
	 *	起動に必要な設定ファイルのパスを問い合わせるハンドラ
	 *	@param enuTag			TFSETTINGXMLTAG
	 *	@param	strFilePath     TF_STRING_W&
	 * (note)
	 *	TAGの種類によって利用するファイルを渡してください。
	 *	失敗させたい場合はfalseを返してください。
	 *
	 */
	virtual bool OnRequestConfigPath(TFSETTINGXMLTAG enuTag, TF_STRING_W& strFilePath);

	/**
	 *	サーバアイテムを直接問い合わせてくるハンドラ
	 *	@param	pItemList	CTFResourceItemList**	アイテムリスト
	 *	(note)
	 *	OnRequestConfigPath()でエラーが帰ってきた場合に再度問い合わせてくるハンドラ
	 *	直接ServerItemを渡したい場合にリストにCTFServerResourceを追加してください。
	 */
	virtual bool OnRequestServerItemList(CTFResourceItemList** pItemList);

	/**
	 *	あるキーを問い合わせてくるハンドラ
	 *	@param	strKey		TF_STRING_A&
	 *	@param	pHintObj	const CTFObject*
	 *
	 *	(note)
	 *	pHintObjの種類
	 *	(a) CTFServerResource		: パスワードのためのキーを取得する為のヒントオブジェクト
	 *
	 */
	virtual void OnQuerySymmetricKey(TF_STRING_A &strKey, const CTFObject* pHintObj);


	/**
	 *	ライブラリが必要とする設定ファイルの場所を問い合わせてくるハンドラ
	 *	@param rItem		CTFLocalFileItem&
	 *	@return boolean
	 *	(note)
	 *	取得に失敗ならfalseを返してください。
	 */
	virtual bool OnSetConfigurationFilePath(CTFLocalFileItem& rItem);


};

TF_END_CLASSEXPORT

#endif

