/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *  $Id$
 *
 *	ファイル名	:	TFWsTransactionHandler.h
 *	クラス名		:	CTFWsTransactionHandler
 *	継承			:
 *
 *	機能　		:	ライブラリ内で主にWorkSession内で利用するための
 *					必要な情報を設定させてくれるハンドラ
 *
 *
 */
#ifndef TF_LIB_TFWSTRANSACTIONHANDLER_H
#define	TF_LIB_TFWSTRANSACTIONHANDLER_H	1

#include "TFLibPublic.h"
#include "TFResourceItem.h"
#include "TFResourceItemList.h"

class CTFLocalFileItem;
class CTFLocalFileItemList;

TF_BEGIN_CLASSEXPORT

class TF_EXPORT CTFWsTransactionHandler
{
public:
	CTFWsTransactionHandler(void);
	virtual ~CTFWsTransactionHandler(void);

	/**
	 * 実行中に利用する言語モードを設定します。
	 * リクエストが発行される度に呼び出されるハンドラです。
	 */
	virtual void OnTransLangMode(TFLANG& enumLang);

	/**
	 *	リクエスト中にライセンスコードが必要になった場合に呼ばれるハンドラ
	 */
	virtual void OnRequestLicense(TF_STRING_A &strLicense);

	/**
	 * リクエストを発行するときに追加で設定するヘッダーを設定できます
	 * リクエストが発行される度に呼び出されるハンドラです。
	 */
	virtual void OnRequestAddHeader(TF_STRING_STRING_MAP mapHeader);

	/**
	 *	DAV CLASS2(LOCK,UNLOCK)を利用しながら処理をするかの問合せが来るハンドラ
	 */
	virtual	bool OnUseDAVCLASS2(void);

	/**
	 *	アイテムがこのライブラリで利用可能なのかを問い合わせてくるハンドラ
	 *	@param		enuType	TFITEMTYPE		アイテムタイプ
	 *	@return	boolean	true : 利用可能 / false : 利用不可能
	 *	(note)
	 *	アイテム毎に処理をtrue/falseで返してください。
	 *	アイテムが作成されるたびに戻ってくるハンドラです。
	 */
	virtual bool OnQueryAcceptItem(TFITEMTYPE enuType);

	/**
	 * 新しく作成するりソース名を問い合わせてくるハンドラ
	 *
	 * @param enuType			TFRESOURCETYPE	TF_RES_FILE ...
	 * @param enuMode			TFTRANSMODE		TF_TRANS_RENAMEとか
	 * @param strName			OI_STRING_A&		作成して欲しい名前
	 * @param nRetry			int					リトライ回数
	 * @return bool
	 *
	 * (note)
	 *	既に存在した場合はstrNameにはその名前が入ってきます。
	 *	新規の場合には""空で問合せがきます。
	 *
	 * TFRESOURCETYPEが「TF_RES_UNKNOWN」の場合もあります。
	 */
	virtual bool OnQueryNewResourceName(TFRESOURCETYPE enuType, TFTRANSMODE enuMode, TF_STRING_A& strName, int nRetry);

	/**
	 *	識別子を問い合わせてくるハンドラ
	 *
	 *	@param enuMode		TFTRANSMODE		トランザクションモード
	 *	@param	strIdent		TF_STRING_W&		識別子
	 *	@param	nLength		int					識別子の長さ(IN)
	 *	@param	nRetry			int					リトライ回数
	 *
	 *	(note)
	 *	TFTRANSMODEに基づいて識別子を設定するハンドラ
	 *	TFTRANSMODEがTF_TRANS_UNKNOWNの場合もあります。
	 *
	 *	識別子に問題があった場合（既に存在しているとか）はnRetryがインクリメント
	 *	されて再度問い合わせがきます。falseを返すことによりキャンセルとなります。
	 *	nLengthを超えた場合の処理は呼ばれた場合の状態に依存します。
	 *	再度問い合わせが来る場合もあればこない場合もあります。
	 */
	virtual bool OnQueryIdentifier(const TFTRANSMODE enuMode, TF_STRING_W& strIdent, const int nLength, int nRetry);

	/**
	 * トランザクションで利用するローカルファイルを問い合わせてくるハンドラ
	 *	ローカルファイルなどをここで渡せば後で詳細内容などの確認を再度聞いてきます。
	 * TODO: まだ未実装
	 */
	virtual bool OnQueryOperationLocalResources(CTFLocalFileItemList& pLocalItemList){return false;};

	/**
	 *	リソースアイテムの詳細を埋める為の最後のハンドラ
	 *	ここでCTFLocalFileItemの内容を変更や全ての項目を埋めることができます。
	 *
	 *	@param pLocalItem		CTFLocalFileItem*		ローカルファイルアイテム
	 *	@param	enuMode		TFTRANSMODE			トランザクションのモード
	 *
	 * (note)
	 *	falseを戻した場合このアイテムは対象外としてその後の処理を行なわないようになります。
	 * 継続して利用する場合は必ずtrueを戻してください。
	 * ファイルがもしこの時点で存在しなくなった場合などはfalseを返してください。
	 */
	virtual bool OnQueryDetailLocalResource(CTFLocalFileItem* pLocalItem, TFTRANSMODE enuMode){return false;};

	/**
	 *	選択されているアイテムの一覧を取得するためのハンドラ
	 *	別に選択されているもの全てを返す必要はありませんが、ここで処理されたアイテム一覧は
	 *	処理結果が個別に報告されます。
	 */
	virtual bool OnQuerySelectedItems(TFDAVMETHOD enuMethod, TFTRANSMODE enuMode, CTFResourceItemList& ptemList);

	/**
	 *	PROPFINDやサーチでのリソースの戻りを返すハンドラ
	 *	@param pItem		CTFResourceItem*
	 *	@return boolean
	 *
	 *	(note)
	 *	結果としてfalseを返した場合、pItemはリストに追加しません。
	 *	リストの結果を受け取りたい場合はtrueを返してください。
	 */
	virtual bool OnShowResource(CTFResourceItem* pItem);

	/**
	 *	DAVのメソッドの処理結果を戻してくるハンドラ
	 *
	 *	@param	nOI_RESULT  const int
	 *	@param	pszURI		const TFXMLCh*
	 *	@param	enuMethod	TFDAVMETHOD
	 *	メソッド単位で戻ってくる為、ここの中で重い処理をやってはいけません。
	 */
	virtual void OnResultDAVMethod(const int nOI_RESULT, const TFXMLCh* pszURI, TFDAVMETHOD enuMethod);

	/**
	 *	システムメッセージを問い合わせてくるハンドラ
	 *	@param	strIndent		TF_STRING_W		設定して欲しい識別子
	 *	@param strMesssage	TF_STRING_W&		メッセージ本文
	 *	@param	bActive		bool&				アクティブフラグ
	 */
	virtual void OnQuerySystemMessage(const TF_STRING_W strIdent, TF_STRING_W& strMessage, bool& bActive);

	/**
	 *	システムのフォルダを問い合わせてくるハンドラ
	 *	CTFLocalFileItemにフォルダをセットしてください。
	 *	このハンドラは失敗してはいけません。必ず成功させてください。
	 *
	 *	@param pItem	CTFLocalFileItem*
	 *	@param nType	int
	 *	@return void
	 *
	 */
	virtual void OnSetSystemPath(CTFLocalFileItem* pItem, int nType);

	enum TF_SYSPATH {
		TF_SYSPATH_NORMAL = 0,
		TF_SYSPATH_CONFIG,
		TF_SYSPATH_TEMP,
		TF_SYSPATH_DOWNLOAD
	};

	/**
	 *	引数のメソッドの動作の前にPROPFINDを行うか問い合わせてくるハンドラ
	 *	@param	enuMode		TFTRANSMODE
	 *	@param	enuMethod	TFDAVMETHOD
	 *	@param	boolean		[ true : PROPFINDを行います(default) / false: PROPFINDを行わない ]
	 *	このハンドラは通常では利用しないハンドラです。
	 *	PROPFINDをあるメソッドの前でなげないということは存在チェックをしない
	 *	ことになります。あまり好ましい動作にはなりません。
	 *	どうしても速度を上げたい場合などに利用してください。デフォルトではPROPFINDを
	 *	行います。
	 */
	virtual bool OnQueryPropfindBeforeMethod(const TFTRANSMODE enuMode, const TFDAVMETHOD enuMethod);


	/**
	 *	処理を終了したローカルリソースを渡してくるハンドラ
	 *	@param enuMode		const TFTRANSMODE		トランザクションモード
	 *	@param enuMethod	const TFDAVMETHOD		HTTPメソッド
	 *	@param pItem			  CTFLocalFileItem*	リソースアイテム
	 *	@param nResult		const TFRESULT			処理結果コード（HTTPステータスではない）
	 *	@return void
	 */
	virtual void OnResultLocalResource( const TFTRANSMODE enuMode,
										const TFDAVMETHOD enuMethod, 
											  CTFLocalFileItem* pItem,
										const TFRESULT nResult);

	/**
	 *	ローカルファイルを再帰的に調べるか否かを問い合わせてくるハンドラ
	 *	@param	unStratum	TF_SIZE_T			階層（何階層目）
	 *	@param	pItem		CTFLocalFileItem*	対象となるローカルアイテム
	 *	@return bool		true: 問い合わせる / false: やらない
	 *	pItemの内部は必要としない場合はfalseを返してください。
	 *	デフォルトは再帰的に読み出します。
	 */
	virtual bool OnQueryRecursiveLocalResource(TF_SIZE_T unStratum,
											   CTFLocalFileItem* pItem);


	/**
	 *	ダウンロードするアイテムを設定してもらうハンドラ
	 *	@param	pItem	CTFLocalFileItem*		設定するアイテム
	 *	@param	pHist	CTFResourceItem*		ローカルアイテムを生成する為のヒントアイテム
	 */
	virtual bool OnQueryDownloadItem(CTFLocalFileItem* pItem, CTFResourceItem* pHint);


	/**
	 *	トランザクション内でネイティブなエラーコードを設定する
	 *	ここに値を設定するとOnDebugPrintが呼ばれて出力を行う必要があります。
	 *	このデータは保持されません。
	 *	@param	nCode		TF_SIZE_T				エラーコード
	 *	@param	enuType		TF_TRANS_ERROR_TYPE		エラー種別（以下参照）
	 *	@param	pObject		CTFObject				アイテムオブジェクト
	 */
	
	typedef enum tagTF_TRANS_ERROR_TYPE
	{
		TF_TRANS_ERROR_TYPE_NONE	= 0,	// このアイテムはなにもエラーはない
		TF_TRANS_ERROR_TYPE_LOCAL	= 1,	// このアイテムはローカル処理エラー
		TF_TRANS_ERROR_TYPE_NET		= 2		// このアイテムはネットワーク処理エラー
	} TF_TRANS_ERROR_TYPE;

	void SetErrorCodeNative(TF_SIZE_T nCode, TF_TRANS_ERROR_TYPE enuType, CTFObject* pObj=NULL);

	/**
	 *	デバッグ出力時に読み出した側で独自に文字列を追加できるハンドラ
	 *	@param	pszExtString	追加文字列（UTF8)
	 *	@return boolean true:文字列追加 / false:追加しない
	 *	(note)
	 *	falseを返すと何も追加情報は書かれません。
	 */
	virtual bool OnDebugExtString(TF_STRING_A& szExtString);

	/**
	 *	デバック文字列が戻ってきます。
	 *	@param pszString	const char*	デバック文字列
	 */
	virtual void OnDebugPrint(const char* pszString);

	/**
	 *	このトランザクションハンドラの特長を設定する
	 *	@param	enuType		属性
	 *	@param	bool		On / Off
	 */
	enum TF_TRANS_FEATURE_TYPE {
		TF_TRANS_FEATURE_NONE		= 0,	// 属性無し
		TF_TRANS_FEATURE_DEBUG		= 1,	// デバック属性
		TF_TRANS_FEATURE_VERBOSE	= 2,	// おしゃべりモード
		TF_TRANS_FEATURE_METHOD_DELETE_FORCE = 3	// 強制削除ヘッダを付ける
	};

	/**
	 *	特徴を追加します。
	 *	@param	enuTypoe	TF_TRANS_FEATURE	// 特徴
	 *	@param	bSwitch		bool				// true : on / false : off
	 */
	void SetFeature(TF_TRANS_FEATURE_TYPE enuType, bool bSwitch);

	/**
	 *	特徴を取得する
	 *	@param	enUType		TF_TRANS_FEATURE	// 取得したい特徴
	 *	@return true / false
	 */	
	bool GetFeature(TF_TRANS_FEATURE_TYPE enuType);

private:
	int m_nFeature;		// トランザクションハンドラ属性

};

TF_END_CLASSEXPORT

#endif

