/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *	$Id$
 *
 *	ファイル名	:	TFXMLServeSettions.h
 *	クラス名	:	CTFXMLServeSettions
 *	継承		:	CTFXMLHolder
 *
 *	機能　		:	サーバの設定ファイルをパースするクラス
 *					
 *					
 *					
 *
 */
#ifndef TF_LIB_TFXMLSERVERSETTIONGS_H
#define TF_LIB_TFXMLSERVERSETTIONGS_H 1

#include "TFLibDefinition.h"
#include "TFXMLHolder.h"
#include "TFXMLTagBase.h"
#include "TFWsSystemInformationHandler.h"

class CTFServerResource;

TF_BEGIN_CLASSEXPORT
class TF_EXPORT CTFXMLServerSettings :
	public CTFXMLHolder
{
public:
	CTFXMLServerSettings(void);
	~CTFXMLServerSettings(void);

	bool LoadXML(TFSETTINGXMLTAG enuType, const TFXMLCh* pszFilePath);
	void AddHandler(TFSETTINGXMLTAG enuTag, CTFXMLTagBase* pHandler);
	void SetSystemInfoHandler(CTFWsSystemInformationHandler* pHandler);
	bool CreateServerDOMDocument(TFSETTINGXMLTAG enuTag, CTFServerResource* pSvrItem);

protected:
	void QueryParser(TFSETTINGXMLTAG enuTag, XNS(DOMElement)* pElement);
	bool ParseXML(TFSETTINGXMLTAG enuTag);

private:
	bool hasTagHandler(TFSETTINGXMLTAG enuTag);

private:
	typedef std::multimap<int, CTFXMLTagBase*>	MMAPTAGHANDLER;
	typedef std::pair<int, CTFXMLTagBase*>		MMAPTAGPAIR;
	MMAPTAGHANDLER								m_pTagHandlerMap;
	CTFXMLTagBase*								m_pTagHandler;
	CTFWsSystemInformationHandler				m_cSysHandler;
	CTFWsSystemInformationHandler*				m_pSysHandler;
};
TF_END_CLASSEXPORT
#endif


