/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *	$Id$
 *
 *	ファイル名	:	TFXMLTagBase.h
 *	クラス名		:	CTFXMLTagBase
 *	継承			:	CTFXMLUtils
 *
 *	機能　		:	XMLファイルをパースするベースクラス
 *					
 *					
 *					
 *
 */
#ifndef TF_LIB_TFXMLTAGBASE_H
#define TF_LIB_TFXMLTAGBASE_H 1

#include "TFLibDefinition.h"
#include "TFXMLUtils.h"
#include "TFWsSystemInformationHandler.h"

TF_BEGIN_CLASSEXPORT
class TF_EXPORT CTFXMLTagBase : public CTFXMLUtils
{
public:
	CTFXMLTagBase(const char* pszChargeElementName);
	virtual ~CTFXMLTagBase(void);

	/*
	 *	指定されたXMLをパースする
	 *	@param	pElement	DOMElement
	 *	@return boolean
	 */
	virtual bool OnParseXML(XNS(DOMElement)* pElement);

	/**
	 *	システムハンドラを追加する
	 *	@param	pHandler	CTFWsSystemInformationHandler
	 */
	void SetHandler(CTFWsSystemInformationHandler* pHandler);

	/**
	 *	このクラスが担当するエレメントの名前かどうかを調べる
	 *	@param	pszElementName	const char*	エレメント名
	 *	@return boolean
	 */
	bool HasElementName(const char* pszElementName);

protected:
	CTFWsSystemInformationHandler*	m_pSysHandler;
	TF_STRING_A						m_strChargeElement;
};
TF_END_CLASSEXPORT
#endif

