#ifndef TF_LIB_TFXMLUTILS_H
#define TF_LIB_TFXMLUTILS_H 1

#include "TFLibDefinition.h"
#include <xercesc/dom/DOM.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/parsers/XercesDOMParser.hpp>
#include <xercesc/framework/LocalFileFormatTarget.hpp>

#if defined(XERCES_HAS_CPP_NAMESPACE)
	#define XNS(name) XERCES_CPP_NAMESPACE::name
#else
	#define XNS(name) name
#endif

TF_BEGIN_CLASSEXPORT

class TF_EXPORT CTFXMLUtils
{
public:
	// Constructor/Destructor
	CTFXMLUtils(void);
	virtual ~CTFXMLUtils(void);

	XNS(DOMElement)* GetRootElement(void);

protected:
	// Namespace Handling 
	bool AppendNamespace(const TFXMLCh*  pszNSURI, const TFXMLCh* szNSPrefix);
	bool RemoveNamespace(const TFXMLCh*  pszNSURI, const TFXMLCh* szNSPrefix);
	
	bool SetDefaultNSURL(const TFXMLCh* pszNSURL, const TFXMLCh* pszNSPrefix);
	const TFXMLCh* GetCurrentNSURL(const TFXMLCh* pszNSURL);

	// DOM Document Handling
	bool Create(const TFXMLCh* pszRootNodeName, const TFXMLCh* pszNSURL, const TFXMLCh* pszNSPrefix, const TFXMLCh* pszXsltURL);
	bool Destroy(void);
	void SetDocument(XNS(DOMDocument)* pDOMDocument, bool bNeedToDestroy);
	XNS(DOMDocument)* GetDocument(void);
	void SetRootElement(XNS(DOMElement)* pRootElement);

	// Element/Attribute Handling
	XNS(DOMElement)* AppendElement(XNS(DOMElement)* pParent, const TFXMLCh* pszElement, const TFXMLCh* pszNSURL=NULL, const TFXMLCh* pszNSPrefix=0);
	bool RemoveElement(XNS(DOMElement)* pElement);
	bool EmptyElement(XNS(DOMElement)* pElement);
	XNS(DOMElement)* GetElement(XNS(DOMElement)* pParent, const TFXMLCh* pszElement, int iIndex=0, const TFXMLCh* pszNSURL=0);
	int GetElementCount(XNS(DOMElement)* pParent, const TFXMLCh* pszElement, const TFXMLCh* pszNSURL=0);
	XNS(DOMElement)* GetChildElement(XNS(DOMElement)* pParent);
	bool GetElementName(XNS(DOMElement)* pElement, TF_STRING_W& strName, TF_STRING_W& strNSURL);

	bool SetAttribute(XNS(DOMElement)* pElement, const TFXMLCh* pszAttribute, const TFXMLCh* pszValue);
	bool SetCDATASection(XNS(DOMElement)* pElement, const TFXMLCh* pszValue);
	bool SetText(XNS(DOMElement)* pElement, const TFXMLCh* pszValue);

	bool GetAttribute(XNS(DOMElement)* pElement, const TFXMLCh* pszAttribute, TF_STRING_W& strValue);
	bool GetCDATASection(XNS(DOMElement)* pElement, TF_STRING_W& strValue);
	bool GetText(XNS(DOMElement)* pElement, TF_STRING_W& strValue);

	// Member Variables
private:
	bool					m_bNeedToDestroy;
	XNS(DOMDocument)*		m_pDOMDocument;
	XNS(DOMElement)*		m_pRootElement;
	TF_STRING_W				m_strDefaultNSURL;
	TF_STRING_W				m_strDefaultNSPrefix;

};

TF_END_CLASSEXPORT

#endif	// TFLIB_HEADER_TFXMLUTILS_H

