/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *  $Id$
 *
 *	ファイル名	:	TFXmlBodyBuilder.h
 *	クラス名	:	CTFXmlBodyBuilder
 *	継承		:	CTFXMLHolder
 *
 *	機能　		:	XMLを作成するクラス
 *
 *
 */

#ifndef	TF_LIB_TFXMLBODYBUILDER_H
#define	TF_LIB_TFXMLBODYBUILDER_H	1

#include "TFXMLHolder.h"

TF_BEGIN_CLASSEXPORT

class TF_EXPORT CTFXmlBodyBuilder :
	public CTFXMLHolder
{
public:
	CTFXmlBodyBuilder(void);
	virtual ~CTFXmlBodyBuilder(void);

	XNS(DOMElement)* GetLastElement(void);
	XNS(DOMElement)* GetElementByName(const TFXMLCh* Name);

	bool Initialize(const TFXMLCh* pszRootNodeName, const TFXMLCh* pszNSURI=NULL,
					const TFXMLCh* pszNSPrefix=NULL,	 const TFXMLCh* pszNsltURL=NULL);
	bool AddDefaultNameSpace(void);
	bool RemoveDefaultNameSpace(void);

	bool AddPropSet(void);
	bool AddPropRemove(void);

	/**
	 *	このクラスのDOMツリーの一番最後の子供としてノードを追加する
	 *
	 *	@param	pszElementName	const TFXMLCh*
	 *	@param	pszNSURI			const TFXMLCh*
	 *	@param	pszNSPrefix		const TFXMLCh*
	 *	@return boolean
	 */
	bool AddPropChild(const TFXMLCh* pszElementName,
					  const TFXMLCh* pszNSURI=NULL,
					  const TFXMLCh* pszNSPrefix=NULL);
					  
	/**
	 *	このクラスのDOMツリーの一番最後の子供と同じ階層にノードを追加する
	 *
	 *	@param	pszElementName	const TFXMLCh*
	 *	@param	pszNSURI			const TFXMLCh*
	 *	@param	pszNSPrefix		const TFXMLCh*
	 *	@return boolean
	 */
	bool AddPropSibling(const TFXMLCh* pszElementName,
						const TFXMLCh* pszNSURI=NULL,
						const TFXMLCh* pszNSprefix=NULL);
	
	/**
	 *	このクラスのDOMツリーの一番最後と同じ階層にノードを追加して
	 *	追加されたノードを返す。
	 *
	 *	@param	pszElementName	const TFXMLCh*
	 *	@param	pszNSURI			const TFXMLCh*
	 *	@param	pszNSPrefix		const TFXMLCh*
	 *	@return DOMElement*
	 */
	XNS(DOMElement)* AddPropFamily(const TFXMLCh* pszElementName,
								   const TFXMLCh* pszNSURI=NULL,
								   const TFXMLCh* pszNSPrefix=NULL);

	/**
	 * 指定されたDOMエレメントの子供を追加する
	 *	正しく追加された場合はその子供を返します
	 *
	 *	@param	pParent			DOMElement*			
	 *	@param	pszElementName	const TFXMLCh*
	 *	@param	pszNSURI			const TFXMLCh*
	 *	@param	pszNSPrefix		const TFXMLCh*
	 *	@return DOMElement*
	 */
	XNS(DOMElement)* AddPropChild(XNS(DOMElement)* pParent,
					  const TFXMLCh* pszElementName,
					  const TFXMLCh* pszNSURI=NULL,
					  const TFXMLCh* pszNSPrefix=NULL);

	/**
	 *	指定されたDOMノードの値を設定する
	 *	bCDATAがTRUEの場合はCDATAとして追加する
	 *
	 *	@param pNode		DOMElement*
	 *	@param	pszValue	const TFXMLCh*
	 *	@param bCDATA		bool
	 */
	bool AddPropNodeValue(XNS(DOMElement)*	pNode,
						   const TFXMLCh*	pszValue,
						   bool				bCDATA=false);

	// search
	bool AddPropSearch(TFSEARCHTYPE enuType);
	bool AddPropSearchMode(TF_SEARCH_MODE enuMode);
		
	// Discovery
	bool AddPropDiscovery(TF_PROP_DISCOVERY enuType);

	// TF:userid
	bool AddPropUID(const TFXMLCh* pszUID);
	
	// TF:name
	bool AddPropName(const TFXMLCh* pszName);

	// TF:mailaddr
	bool AddPropMailAddr(const TFXMLCh* pszMailAddr);

	// TF:comment
	bool AddPropComment(const TFXMLCh* pszComment, bool bCDATA=true);

	// TF:password
	bool AddPropPassword(const TFXMLCh* pszPassword);

	// TF:admin
	bool AddPropAdmin(bool bAdmin);

	// TF:maxresource
	bool AddPropMaxResource(TF_SIZE_T unCount);

	// TF:usedresource
	bool AddPropUsedResource(TF_SIZE_T unCount);

	// TF:maxstorage
	bool AddPropMaxStorage(TF_SIZE_T unSize);

	// TF:usedstorage
	bool AddPropUsedStorage(TF_SIZE_T unSize);

	// TF:acccessdeny
	bool AddPropAccessDeny(const TFXMLCh* pszDeny);

	// TF:userstatus
	bool AddPropUserStatus(TFUSERSTATUS	nStatus);

	// TF:user-privilege
	bool AddPropUserPrivilege(TFUSERPRIV nPriv);

	// TF:usertype
	bool AddPropUserType(const TFXMLCh* pszType);

	// TF:expiration
	bool AddPropExpiration(time_t time);

	// TF:maxusercreation
	bool AddPropMaxusercreation(TF_SIZE_T unCounts);

	// TF:msgid
	bool AddPropMsgID(const TFXMLCh* pszID);

	// TF:msgtxt
	bool AddPropMsgTxt(const TFXMLCh* pszMsg);

	// TF:active
	bool AddPropActive(bool bActive);
	
	// TF:groupmailwatch
	// TF:triggermethod
	bool AddPropGroupMailWatch(int nMethods);
	
	// TF:groupid
	bool AddPropGroupID(const TFXMLCh* pszID);

	// TF:groupuri
	bool AddPropGroupUri(const TFXMLCh* pszuri);

	// TF:state ( group )
	bool AddPropGroupState(int nState);

	// TF:constraints
	bool AddPropGroupConstraints(int nConstraints);

	// TF:charngeleader
	bool AddPropChangeLeader(const TFXMLCh* userid, TFCHANGELEADERTYPE nType);

	// TF:lastaccessclient
	bool AddPropLastAccessClient(const TFXMLCh* pszClient);
	
	// TF:lineup
	bool AddPropLineup(const TFXMLCh* pszLineup);
	
// これ以下は通常利用すべきものではありません =====================

	// TF:creationdt
	bool AddPropCreationDt(time_t time);

	// TF:updatedt
	bool AddPropUpdateDt(time_t time);

	// TF:lastaccessdt
	bool AddPropLastAccessDt(time_t time);

	// TF:ownername
	bool AddPropOwnerName(const TFXMLCh* pszName);

	// TF:ownerid
	bool AddPropOwnerID(const TFXMLCh* pszID);

	// TF:otheruser
	bool AddPropOtheruser(bool bIsOther);

// ここまで =====================================================

private:
	XNS(DOMElement)*		m_lpLast;
	
};

TF_END_CLASSEXPORT

#endif

