/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *  $Id$
 *
 *	ファイル名	:	TFXmlBodyPaserBase.h
 *	クラス名	:	CTFXmlBodyPaserBase
 *	継承		:	CTFXmlUtils
 *
 *	機能　		:	XMLのボディをパースするベースクラス
 *					
 *
 *
 */
#ifndef TF_LIB_TFXMLBODYPASERBASE_H
#define TF_LIB_TFXMLBODYPASERBASE_H 1

#include "TFXMLUtils.h"
#include "TFDavResource.h"

TF_BEGIN_CLASSEXPORT
class TF_EXPORT CTFXmlBodyPaserBase :
	public CTFXMLUtils
{
public:
	CTFXmlBodyPaserBase(const TFXMLCh* pszServerID);
	~CTFXmlBodyPaserBase(void);
protected:
	CTFDavResource* ParseDiscovery(XNS(DOMElement)* pParentElement);

	bool GetDAVHref(XNS(DOMElement)* pParentElement, TF_STRING_W& strHref);

	bool GetTFChildElementName(XNS(DOMElement)* pParentElement, const TFXMLCh* pszElementName, TF_STRING_W& strChildElementName);
	bool GetTFElementText(XNS(DOMElement)* pParentElement, const char* pszElementName, TF_STRING_W& strValue );
	bool GetTFElementCDATASection(XNS(DOMElement)* pParentElement, const char* pszElementName, TF_STRING_W& strValue );
	bool GetTFElementAutoText(XNS(DOMElement)* pParentElement, const char* pszElementName, TF_STRING_W& strValue );
	XNS(DOMElement)* GetTFChildElement(XNS(DOMElement)* pParentElement, const char* pszElementName);

	virtual CTFDavResource* OnTFNoDiscoveryFound(XNS(DOMElement)* pResponse) {return 0;};
	virtual CTFDavResource* OnTFUserDiscoveryFound(XNS(DOMElement)* pUserDiscovery)  {return 0;};
	virtual CTFDavResource* OnTFGroupDiscoveryFound(XNS(DOMElement)* pGroupDiscovery) {return 0;};
	virtual CTFDavResource* OnTFSqlDiscoveryFound(XNS(DOMElement)* pSqlDiscovery) {return 0;};
	virtual CTFDavResource* OnTFSysmsgDiscoveryFound(XNS(DOMElement)* pSysmsgDiscovery) {return 0;};
	virtual CTFDavResource* OnTFStatusDiscoveryFound(XNS(DOMElement)* pStatusDiscovery) {return 0;};
	virtual CTFDavResource* OnTFDbmsDiscoveryFound(XNS(DOMElement)* pDbmsDiscovery) {return 0;};
	virtual CTFDavResource* OnTFSqlPreferenceDiscoveryFound(XNS(DOMElement)* pSqlPriferenceDiscovery) {return 0;};
	virtual CTFDavResource* OnTFDbmsErrDiscoveryFound(XNS(DOMElement)* pDbmsErrDiscovery) {return 0;};
	virtual CTFDavResource* OnTFAnalysisErrDiscoveryFound(XNS(DOMElement)* pAnalysisErrDiscovery) {return 0;};
	virtual CTFDavResource* OnTFUpdateDiscoveryFound(XNS(DOMElement)* pUpdateDiscovery) {return 0;};
	virtual CTFDavResource* OnTFDependSqlDiscoveryFound(XNS(DOMElement)* pDependSqlDiscovery) {return 0;};

private:
	TF_STRING_W	m_strNSURL_TF;
	TF_STRING_W	m_strNSURL_DAV;

protected:
	TF_STRING_W	m_strServerID;		//< サーバID

};

TF_END_CLASSEXPORT
#endif	// TF_LIB_TFXMLBODYPASERBASE_H

