#ifndef TF_LIB_TFXMLBODYPROPFIND_H
#define TF_LIB_TFXMLBODYPROPFIND_H	1

#include <onion/RBPVDXmlPropfind.h>
#include "TFXmlBody.h"

typedef enum tagTFLIVEPROP
{
	LP_NONE						= 0x00000000,
	LP_ALL						= 0xFFFFFFFF,
	// DAV
	LP_CREATIONDATE				= 0x00000001,
	LP_DISPLAYNAME    			= 0x00000002,
	LP_GETCONTENTLANGUAGE		= 0x00000004,	// NON supported
	LP_GETCONTENTLENGTH			= 0x00000008,
	LP_GETCONTENTTYPE 			= 0x00000010,
	LP_GETETAG					= 0x00000020,
	LP_GETLASTMODIFIED  		= 0x00000040,
	LP_RESOURCETYPE    			= 0x00000080,
	LP_RESOURCE					= 0x00000100,	// NON support
	LP_SUPPORTEDLOCK			= 0x00000200,
	LP_LOCKDISCOVERY			= 0x00000400,
	LP_SUPPOREDQUERYGRAMMERSET	= 0x00000800,	// NON support
	LP_SUPPOTEDMETHOD			= 0x00001000,	// unused by TF
	LP_QUOTABYTES				= 0x00002000,	// NON support
	LP_QUOTAUSEDBYTE			= 0x00004000,	// NON support
	LP_STORAGEQUOTAREACHED		= 0x00008000,	// NON support

	// プロパティの表示時
	LP_DETAIL					=	  LP_CREATIONDATE
									| LP_DISPLAYNAME
									| LP_GETCONTENTLENGTH
									| LP_GETCONTENTTYPE
									| LP_GETETAG
									| LP_GETLASTMODIFIED
									| LP_RESOURCETYPE
									| LP_SUPPORTEDLOCK
									| LP_LOCKDISCOVERY,

	// 通常の情報取得時(リスト等)
	LP_CONVENTIONAL				=	  LP_CREATIONDATE
									| LP_DISPLAYNAME
									| LP_GETCONTENTLENGTH
									| LP_GETCONTENTTYPE
									//| LP_GETETAG
									| LP_GETLASTMODIFIED
									| LP_RESOURCETYPE
									//| LP_SUPPORTEDLOCK
									| LP_LOCKDISCOVERY,

	// ロック確認時(シーケンス中)
	LP_LOCKCHECK				=	  LP_CREATIONDATE
									| LP_DISPLAYNAME
									| LP_GETCONTENTLENGTH
									| LP_GETCONTENTTYPE
									//| LP_GETETAG
									| LP_GETLASTMODIFIED
									| LP_RESOURCETYPE
									//| LP_SUPPORTEDLOCK
									| LP_LOCKDISCOVERY,


	// D&D時(GETリスト)
	LP_SIMPLECHECK				=	  LP_CREATIONDATE			// NULLロック検出のために必要
									| LP_DISPLAYNAME
									| LP_GETCONTENTLENGTH
									| LP_GETCONTENTTYPE
									//| LP_GETETAG
									| LP_GETLASTMODIFIED
									| LP_RESOURCETYPE
									//| LP_SUPPORTEDLOCK
									| LP_LOCKDISCOVERY,			// NULLロック検出のために必要

	// 存在確認
	LP_EXISTCHECK				=	LP_CREATIONDATE				// NULLロック検出のために必要
									| LP_DISPLAYNAME
									//| LP_GETCONTENTLENGTH
									//| LP_GETCONTENTTYPE
									//| LP_GETETAG
									//| LP_GETLASTMODIFIED
									| LP_RESOURCETYPE
									//| LP_SUPPORTEDLOCK
									| LP_LOCKDISCOVERY,			// NULLロック検出のために必要

} TFLIVEPROP;

typedef enum tagTFLIVEPROPEX
{
	// TF
	LP_EX_NONE						= 0x00000000,
	LP_EX_ALL						= 0xFFFFFFFF,
	LP_EX_CREATOR					= 0x00000001,
	LP_EX_LASTMODIFIER				= 0x00000002,
	LP_EX_SHAREDCOLLECTION			= 0x00000004,
	LP_EX_MAILWATCH					= 0x00000008,
	LP_EX_TRASHINFORMATION			= 0x00000010,
	LP_EX_RESOURCESTATE				= 0x00000020,	// extended feature
	LP_EX_USERPRIVILEGEGRANTSET		= 0x00000040,	// extended feature
	LP_EX_SYSTEMQUOTA				= 0x00008000

} TFLIVEPROPTF;

typedef enum tagTFDEADPROP
{
	DP_NONE							= 0x00000000,
	DP_ALL							= 0xFFFFFFFF,

	// for TF
	DP_COMMENT						= 0x00000001,

	// 通常の情報取得時(リスト等)
	DP_CONVENTIONAL					= DP_NONE,

	// プロパティ表示時
	DP_DETAIL						= DP_ALL

} TFDEADPROP;

TF_BEGIN_CLASSEXPORT
class TF_EXPORT CTFXmlBodyPropfind : public CRBPVDXmlPropfind, CTFXmlBody
{
public:
		CTFXmlBodyPropfind(void);
		virtual ~CTFXmlBodyPropfind(void);
		
		bool CreateBody(TFLIVEPROP enuLive, TFLIVEPROPTF enuLiveEx, TFDEADPROP enuDead);
};

TF_END_CLASSEXPORT
#endif

