#ifndef	TF_LIB_OIMAP_H
#define	TF_LIB_OIMAP_H	1

/**
 *	$Id$
 *	Onionで利用されている定義を利用する為のマッピングヘッダ
 *	
 */

#include "onion/DavLock.h"
#include "stdtypes.h"

typedef std::vector<CDavLock>               LOCKLIST, *PLOCKLIST;

#define HAS_LOCK(Locks)                 (!(Locks).empty())
#define C2W(x)							((const TFXMLCh*)X(x))

/*
 * OPTIONSの文字列とのマッピングを構成する構造体
 */
typedef struct tagTFDAVMETHODTABLE
{
	const char		*szMethod;
	TFDAVMETHOD		iMethod;
} TFDAVMETHODTABLE, *PTFDAVMETHODTABLE;

const TFDAVMETHODTABLE TF_DAV_METHODTABLE[] =
{
	{	OI_METHOD_OPTIONS,		TF_DAV_OPTIONS	},
	{	OI_METHOD_HEAD,			TF_DAV_HEAD		},
	{	OI_METHOD_POST,			TF_DAV_POST		},
	{	OI_METHOD_GET,			TF_DAV_GET		},
	{	OI_METHOD_PUT,			TF_DAV_PUT		},
	{	OI_METHOD_PROPFIND,		TF_DAV_PROPFIND	},
	{	OI_METHOD_PROPPATCH,	TF_DAV_PROPPATCH},
	{	OI_METHOD_DELETE,		TF_DAV_DELETE	},
	{	OI_METHOD_COPY,			TF_DAV_COPY		},
	{	OI_METHOD_MOVE,			TF_DAV_MOVE		},
	{	OI_METHOD_MKCOL,		TF_DAV_MKCOL	},
	{	OI_METHOD_LOCK,			TF_DAV_LOCK		},
	{	OI_METHOD_UNLOCK,		TF_DAV_UNLOCK	},
	{	OI_METHOD_SEARCH,		TF_DAV_SEARCH	},
	{	NULL,					TF_DAV_UNKNOWN	}	//←必ず最後の要素にすること
};


#endif

