/**
 *	STLによる型定義
 *
 *
 */

#ifndef TF_LIB_STDTYPES_H
#define TF_LIB_STDTYPES_H 1

#include <string>
#include <vector>
#include <list>
#include <map>

#include "types.h"

#ifndef _WIN32
	#include "ushort_traits.h"
	#include "uchar_traits.h"
#endif

/* onion OI_STRING_A type */
typedef std::basic_string<char>       TF_STRING_A;

/* wide char basic_string */
typedef std::basic_string<TFXMLCh>    TF_STRING_W;

/* UTF8 char basic_string */
typedef std::basic_string<TFXMLByte>  TF_STRING_B;

/* tchar (win32) */
typedef std::basic_string<TFCHAR>     TF_STRING_T;

/* OI_STRSTREAM_A type */
typedef std::stringstream             TF_STRSTREAM_A;

/* wide char stringstream */
typedef std::wstringstream            TF_STRSTREAM_W;

/* wide char (TF_STRING_W) vector */
typedef std::vector<TF_STRING_W>	  TF_STRVECTOR_W;

/* OI_STRLIST_A type */
typedef std::vector<TF_STRING_A>	  TF_STRLIST_A;

/* wide char TF_STRING_W List */
typedef std::vector<TF_STRING_W>	  TF_STRLIST_W;

#endif /* TF_LIB_STDTYPES_H */
