#ifndef TF_LIB_TYPES_H
#define TF_LIB_TYPES_H 1
/**
 *	$Id$
 *	ライブラリ内部で利用する型
 *	外部から利用するときは必ずここにある型を利用すること
 *	ライブラリ内部で利用されている型（例えばOI_STRING_A)などは利用しないこと
 *
 */

/*
 * コンパイル環境チェック
 */

#if defined(_WIN32)

#	define TF_PLATFORM_WIN32 1				//	Windows

#elif defined(__MWERKS__) && !(__MACH__)

#	define TF_PLATFORM_MACOS_PEF 1			//	MacOS Classic (PEF)

#elif defined(__MACH__) && __MACH__

#	define TF_PLATFORM_MACOS_MACHO 1		//	MacOS X (Mach-O)

#else

#	define TF_PLATFORM_LINUX 1				// Linux
#include <sys/types.h>

#endif


/*
 *	文字型の定義
 */

#if defined(TF_PLATFORM_WIN32)

#include <tchar.h>
typedef unsigned short                TFXMLCh;
typedef unsigned char                 TFXMLByte;
typedef TCHAR                         TFCHAR;
typedef	void *                        TFStringHandle;

#elif defined(TF_PLATFORM_MACOS_PEF) || defined(TF_PLATFORM_MACOS_MACHO)

typedef unsigned short                TFXMLCh;
typedef unsigned char                 TFXMLByte;
typedef char                          TFCHAR;
typedef	CFStringRef                   TFStringHandle;

#else

/*
typedef @TFXMLCH@                     TFXMLCh;
typedef @TFXMLBYTE@                   TFXMLByte;
typedef @TFCHAR@                      TFCHAR;
*/
typedef unsigned short                TFXMLCh;
typedef unsigned char                 TFXMLByte;
typedef char                          TFCHAR;
typedef	void *                        TFStringHandle;

#endif


/* handle */
typedef void*                         TFHANDLE;

#ifdef _WIN32
   typedef unsigned __int64      TF_SIZE_T;
   typedef __int64               TF_SSIZE_T;
#  define TF_STRTOUL(p, pp, l)   _atoi64(p)
#  define TF_FSTAT(h, p)         _fstati64(h, p)
#  define TF_SIZEFORMAT          "%I64u"
#  define TF_SSIZEFORMAT         "%I64"
#elif defined (__MWERKS__)
   typedef unsigned long         TF_SIZE_T;
   typedef long                  TF_SSIZE_T;
#  define TF_STRTOUL(p, pp, l)   atoi(p)
#  define TF_FSTAT(h, p)         fstat(h, p)
#  define TF_SIZEFORMAT          "%lu"
#  define TF_SSIZEFORMAT         "%ld"
#else /* POSIX */
   typedef off_t                 TF_SIZE_T;
   typedef off_t                 TF_SSIZE_T;
#  if defined(_FILE_OFFSET_BITS) && (_FILE_OFFSET_BITS == 64) /*Linux,Solaris*/
#    define TF_USESTAT64
#    define TF_STRTOUL(p, pp, l) strtoull(p, pp, l)
#    define TF_FSTAT(h, p)       fstat64(h, p)
#    define TF_SIZEFORMAT        "%llu"
#    define TF_SSIZEFORMAT       "%lld"
#  elif SIZEOF_OFF_T >= 8 /*BSD platforms with large file*/
#    define TF_STRTOUL(p, pp, l) strtoul(p, pp, l)
#    define TF_FSTAT(h, p)       fstat(h, p)
#    define TF_SIZEFORMAT        "%llu"
#    define TF_SSIZEFORMAT       "%lld"
#  else
#    define TF_STRTOUL(p, pp, l) strtoul(p, pp, l)
#    define TF_FSTAT(h, p)       fstat(h, p)
#    define TF_SIZEFORMAT        "%lu"
#    define TF_SSIZEFORMAT       "%ld"
#  endif
#endif

#endif /* TF_LIB_TYPES_H */
