#ifndef _H_USHORT_TRAITS
#define _H_USHORT_TRAITS

#include <string.h>
#include <cstdio>
#include <string>

namespace std
{
	template<>
		struct char_traits<unsigned short>
	{
		typedef unsigned short	char_type;
		typedef int				int_type;
		//typedef streampos		pos_type;
		//typedef streamoff		off_type;
		//typedef mbstate_t	 	state_type;
		
		static void 
		assign(char_type& __c1, const char_type& __c2) {
			__c1 = __c2;
		};

		static bool 
		eq(const char_type& __c1, const char_type& __c2) {
			return __c1 == __c2;
		};

		static bool 
		lt(const char_type& __c1, const char_type& __c2) {
			return __c1 < __c2;
		};

		static int 
		compare(const char_type* __s1, const char_type* __s2, size_t __n) {
			return memcmp(__s1, __s2, __n * sizeof(char_type));
		};

		static size_t
		length(const char_type* __s) {
			char_type* p = const_cast<char_type*>(__s);
			for( ; *p ; p++ );
			return p-__s;
		};

		static const char_type* 
		find(const char_type* __s, size_t __n, const char_type& __a) {
			char_type* p = const_cast<char_type*>(__s);
			for( ; *p && ((p-__s)<__n); p++ ) {
				if( *p == __a )
					return p;
			}
			return NULL;
		};

		static char_type* 
		move(char_type* __s1, const char_type* __s2, size_t __n) {
			return static_cast<char_type*>(memmove(__s1, __s2, __n * sizeof(char_type)));
		};

		static char_type* 
		copy(char_type* __s1, const char_type* __s2, size_t __n) {
			return static_cast<char_type*>(memcpy(__s1, __s2, __n * sizeof(char_type)));
		};

		static char_type* 
		assign(char_type* __s, size_t __n, char_type __a) {
			char_type* p = const_cast<char_type*>(__s);
			for( ; (p-__s)<__n; p++ )
				*p = __a;
			return p;
		};

		static char_type 
		to_char_type(const int_type& __c) {
			return static_cast<char_type>(__c);
		};

		static int_type 
		to_int_type(const char_type& __c) {
			return static_cast<int_type>(__c);
		};

		static bool 
		eq_int_type(const int_type& __c1, const int_type& __c2) {
			return __c1 == __c2;
		};

		static int_type 
		eof() {
			return static_cast<int_type>(EOF);
		};

		static int_type 
		not_eof(const int_type& __c) {
			return (__c == eof()) ? 0 : __c;
		};

	};
}	// namespace std

#endif	// _H_USHORT_TRAITS
