#include "TFLinuxLocalFileItem.h"
#include "oimap.h"

TFLIB_IMPLEMENT_CLASS(CTFLinuxLocalFileItem,"CTFLinuxLocalFileItem")

CTFLinuxLocalFileItem::CTFLinuxLocalFileItem(void)
{
//	m_nFD = -1;
	TFLIB_CONSTRUCT_CLASS(CTFLinuxLocalFileItem);
}

CTFLinuxLocalFileItem::~CTFLinuxLocalFileItem(void)
{
	m_strPath.erase();
	m_strPathA.erase();
	m_strURI.erase();
}

void 
CTFLinuxLocalFileItem::Import(const CTFObject& source)
{
	TFLIB_PREPARE_IMPORT(CTFLinuxLocalFileItem, CTFLocalFileItem, source, psource);

	m_strPath	= psource->m_strPath;
	m_strPathA  = psource->m_strPathA;
	m_strURI	= psource->m_strURI;

}

/**
 *	ѥꤹ
 */
int 
CTFLinuxLocalFileItem::SetPath(int iFlags, void *pBuffer, int iSize)
{
	if (iSize == sizeof(TFXMLCh))
	{
		m_strPath = (const TFXMLCh*)pBuffer;
	}
	else
	{
		m_strPath.erase();
		m_strPathA = (const char*)pBuffer;
	}
}

/**
 *	ѥμ
 *	@return		int	
 */
int
CTFLinuxLocalFileItem::GetPath(int iFlags, void **ppBuffer, int *piSize) const
{
	if (!m_strPath.empty())
	{
		*ppBuffer = (void*)m_strPath.c_str();
		*piSize    = sizeof(TFXMLCh);

		return TF_TRUE;
	}

	return TF_FAIL;
}

const char*
CTFLinuxLocalFileItem::GetPathA(void)
{
	if (m_strPathA.empty())
			m_strPathA = (const char*)X(m_strPath.c_str()).UTF8().c_str();
	return m_strPathA.c_str();
}

const TFXMLCh*
CTFLinuxLocalFileItem::GetPathW(void)
{
	if (m_strPath.empty())
		m_strPath = (const TFXMLCh*)X((TFXMLByte *)m_strPathA.c_str());
	return m_strPath.c_str();
}

void
CTFLinuxLocalFileItem::SetURI(const TFXMLCh* pszURI)
{
	m_strURI = pszURI;
}

const TFXMLCh*
CTFLinuxLocalFileItem::GetURI(void) const
{
	return m_strURI.c_str();
}

void
CTFLinuxLocalFileItem::Initialize(void)
{
	m_strURI.erase();
	m_strPath.erase();
	m_strPathA.erase();
	m_unSize = 0L;
//	m_nFD = -1;
	m_strURI.erase();
	m_unAttr = 0L;
}


