#ifndef TF_LIB_LINUXLOCALFILEUTILS_H
#define TF_LIB_LINUXLOCALFILEUTILS_H	1
/**
 *  Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *  $Id$
 *
 *	ե̾	:	TFLinuxLocalFileUtils.h
 *	饹̾	:	CTFLinuxLocalFileUtils
 *	Ѿ		:	TFLocalFileUtils
 *
 *	ǽ		:	ʥե뤿Υ桼ƥƥ饹
 *
 *
 */

#include "TFLocalFileUtils.h"
#include "TFLocalFileItem.h"
#include "TFLocalFileItemList.h"

class CTFLinuxLocalFileUtils : public CTFLocalFileUtils
{
public:

	CTFLinuxLocalFileUtils(void);
	virtual ~CTFLinuxLocalFileUtils(void);

	TFFSTAT BuildLocalFileItem(CTFLocalFileItem& rItem, const CTFLocalFileItem& rHintItem) const;

	TFFSTAT Open(CTFLocalFileItem& cFile, int nFlags) const;
	TFFSTAT Write(int nFD, const char* pszString, TF_SIZE_T size);

	TFFSTAT Close(CTFLocalFileItem& cFile) const;
	TFFSTAT Unlink(CTFLocalFileItem& cFile) const;
	TFFSTAT Mkdir(CTFLocalFileItem& cFile, bool bParent) const;

	TFFSTAT GetFileAttr(CTFLocalFileItem& cFile) const;
	bool ResourceExist(CTFLocalFileItem& rFile) const;
	TFFSTAT EnumLocalFiles(CTFLocalFileItemList* pItemList, CTFLocalFileUtils *pUtils, TF_SIZE_T& unTotalSize);

	int CompareDateTime(CTFLocalFileItem* pItem1, CTFLocalFileItem *pItem2);
	void GetErrorMessage(TF_SIZE_T nErrorCode, TF_STRING_A& strMessage);

private:
	TFFSTAT InternalEnumLocalFiles(const TFXMLCh* strFolder, CTFLocalFileItemList* pItemList, CTFLocalFileUtils *pUtil, TF_SIZE_T& unTotalSize);
	void setFileAttribute(CTFLocalFileItem* pItem, TF_SIZE_T unAttributes);

    TFFSTAT SetTime(CTFLocalFileItem* pFile, time_t at=NULL, time_t ut=NULL);
	TFFSTAT SetTimeTemporary(CTFLocalFileItem* pFile, time_t at=NULL, time_t ut=NULL);

};

#endif

