#include "TFBroadCaster.h"

CTFCriticalSection CTFBroadCaster::m_cBroadCritSect;
unsigned int CTFBroadCaster::m_unCount = 0;
LPBROWSERHANDLER	CTFBroadCaster::m_vBrowserHandler;

CTFBroadCaster::CTFBroadCaster(void)
{
}

CTFBroadCaster::~CTFBroadCaster(void)
{
}


bool
CTFBroadCaster::AddHandler(CTFWsBrowserHandler* pHandler)
{

	CTFCriticalSectionLocker	cLock(m_cBroadCritSect);

	pHandler->m_unID = ++m_unCount;

	m_vBrowserHandler.push_back(pHandler);

	return true;
}

bool
CTFBroadCaster::DeleteHandler(CTFWsBrowserHandler* pHandler)
{
	CTFCriticalSectionLocker	cLock(m_cBroadCritSect);

	bool bResult = false;

	LPBROWSERHANDLER::iterator it = m_vBrowserHandler.begin();
	for (; it != m_vBrowserHandler.end(); )
	{
		if ((*it)->m_unID == pHandler->m_unID)
		{
			m_vBrowserHandler.erase(it);
			bResult = true;
			break;
		}
		it++;
	}

	return bResult;
}

bool
CTFBroadCaster::HasHander(void)
{
	CTFCriticalSectionLocker	cLock(m_cBroadCritSect);

	return !m_vBrowserHandler.empty();
}


