/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *
 *	ファイル名	:	TFClassInfo.cpp
 *  クラス名		:	CTFClassInfo
 *	継承			:
 *
 *	機能　		:	クラス情報の保持を行う。CTFObjectクラスと共に用いる。
 *
 *
 */

#include "TFClassInfo.h"

/**
 *	コンストラクタ。
 *	このコンストラクタは使用していない。
 *
 */
CTFClassInfo::CTFClassInfo(void)
{
	m_pfnCreateObject = 0;
	m_szClassName = 0;
}

/**
 *	コンストラクタ（クラス名情報入り）
 *
 *	@param	fncCO	TFCreateObjectFnc	動的生成用関数(CreateXXXXObject)のポインタ
 *	@param	szClassName	const char*		クラス名文字列（文字列定数を指定すること）
 *	
 */
CTFClassInfo::CTFClassInfo(TFCreateObjectFnc fncCO, const char* szClassName)
{
	m_szClassName = szClassName ? szClassName : "";
	m_pfnCreateObject = fncCO;
}

/**
 *	デストラクタ
 *
 */
CTFClassInfo::~CTFClassInfo(void)
{
}

/**
 *	新しいオブジェクトを生成する
 *
 *	@return	CTFObject*	新しいオブジェクト
 */
CTFObject *CTFClassInfo::CreateObject()
{
	return	m_pfnCreateObject ? (*m_pfnCreateObject)() : 0;
}




