#include "TFCriticalSection.h"

#ifdef _WIN32
#include <windows.h>
#endif

CTFCriticalSection::CTFCriticalSection(void)
{

#if _WIN32
	::InitializeCriticalSection((CRITICAL_SECTION*)m_buffer);
#elif defined(macintosh)
# ifdef __MACH__
	// Mach-O環境のMacintosh・・・MacOS X専用

	m_refCount		= 0;
	m_refThreadID	= 0;

	pthread_mutex_init(&m_SyncObj,0);

# else
	// Mach-O環境ではない（PEF環境の）Macintosh・・・MacOS 9/MacOS X両方
	if( MPLibraryIsLoaded() )
	{
		MPCreateCriticalRegion(&m_SyncObj);
	}
# endif /* __MACH__ */
#else
  // その他
#endif

}

CTFCriticalSection::~CTFCriticalSection(void)
{

#if _WIN32
	// WINDOWS
	::DeleteCriticalSection((CRITICAL_SECTION*)m_buffer);
#elif defined(macintosh)
# ifdef __MACH__
	// Mach-O環境のMacintosh・・・MacOS X専用
	pthread_mutex_destroy(&m_SyncObj);
# else
   // Mach-O環境ではない（PEF環境の）Macintosh・・・MacOS 9/MacOS X両方
	MPDeleteCriticalRegion(&m_SyncObj);
# endif /* __MACH__ */
#else
  // その他
#endif
}

void
CTFCriticalSection::Enter(void)
{

#if _WIN32
	::EnterCriticalSection((CRITICAL_SECTION*)m_buffer);
#elif defined(macintosh)
# ifdef __MACH__
   // Mach-O環境のMacintosh・・・MacOS X専用

	if( ! pthread_mutex_trylock(&m_SyncObj) ) /* まずmutexでロックを試みる */
	{
		m_refThreadID = pthread_self();
		m_refCount = 1;
	}
	else
	{
		if( pthread_equal(pthread_self(), m_refThreadID) )
		{
			m_refCount++;
		}
		else
		{
			pthread_mutex_lock(&m_SyncObj); /* 他のスレッドがmutexを離すまで待つ */
			m_refThreadID = pthread_self();
			m_refCount = 1;
		}
	}


# else
   // Mach-O環境ではない（PEF環境の）Macintosh・・・MacOS 9/MacOS X両方
	MPEnterCriticalRegion(&m_SyncObj, 0x7FFFFFFF);

# endif /* __MACH__ */
#else
  // その他
#endif

}

void
CTFCriticalSection::Leave(void)
{

#if _WIN32
	::LeaveCriticalSection((CRITICAL_SECTION*)m_buffer);
#elif defined(macintosh)
# ifdef __MACH__

	// Mach-O環境のMacintosh・・・MacOS X専用
	if( (--m_refCount) == 0 )
		pthread_mutex_unlock(&m_SyncObj);

# else
   // Mach-O環境ではない（PEF環境の）Macintosh・・・MacOS 9/MacOS X両方
	MPExitCriticalRegion(&m_SyncObj);

# endif /* __MACH__ */
#else
  // その他
#endif

}


