/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *
 *	ファイル名	:	TFDavResourceList.h
 *  クラス名		:	CTFDavResourceList
 *	継承			:	CTFResourcePropTF
 *
 *	機能　		:	リソースリストを保持するクラス。
 *					CTFDavResourceオブジェクトの一覧(vector)を持つ。
 *					CTFResourcePropTFの派生クラスのため、
 *					自分自身もDavリソースの保持が可能。
 *
 */

#include "TFDavResourceList.h"

TFLIB_IMPLEMENT_CLASS(CTFDavResourceList,"CTFDavResourceList")

CTFDavResourceList::CTFDavResourceList(void)
{
	TFLIB_CONSTRUCT_CLASS(CTFDavResourceList);
}

CTFDavResourceList::~CTFDavResourceList(void)
{
}

void CTFDavResourceList::Import(const CTFObject& source)
{
	TFLIB_PREPARE_IMPORT(CTFDavResourceList,CTFResourcePropTF,source,psource);

	// リストを取り込む
	ImportList((CTFTmplItemList<CTFDavResource>*)psource);
}

/**
 *	GetItem
 *	メンバのアイテムリストからURIを元に対象のアイテムを返却する。
 *
 *	@param		pszURI				const TFXMLCh*
 *	@return	CTFDavResource*	
 *
 */
 
CTFDavResource*
CTFDavResourceList::GetItemWithURI(const TFXMLCh* pszURI)
{
	if (IS_EMPTY(pszURI)) return NULL;

	TF_STRING_W	strURI(pszURI);

	return FindItem(TFDAVRESOURCELIST_FINDBYURI, (void *)&strURI);
}

CTFDavResource*
CTFDavResourceList::GetItemWithServerID(const TFXMLCh* pszServerID)
{
	if (IS_EMPTY(pszServerID)) return NULL;

	TF_STRING_W	strServerID(pszServerID);

	return FindItem(TFDAVRESOURCELIST_FINDBYSERVERID, (void *)&strServerID);
}

CTFDavResource*
CTFDavResourceList::GetItemWithName(const TFXMLCh* pszName)
{
	if (IS_EMPTY(pszName)) return NULL;

	TF_STRING_W	strName(pszName);

	return FindItem(TFDAVRESOURCELIST_FINDBYNAME, (void *)&strName);
}

CTFDavResource*
CTFDavResourceList::GetItemWithIndex(int nIndex)
{
	if (nIndex < 0) return NULL;
	size_t size = GetItemCount();
	if (size < (size_t)nIndex) return NULL;

	return GetItem(nIndex);
}

CTFDavResource*
CTFDavResourceList::OnCloneItem(CTFDavResource* source)
{
	CTFObject* newItem = source->Clone();
	return (CTFDavResource*)newItem;
}

bool
CTFDavResourceList::OnCheckItem(CTFDavResource* target, int iHint, void* pHint)
{
	switch(iHint)
	{
	case TFDAVRESOURCELIST_FINDBYURI:
		return (((TF_STRING_W *)pHint)->compare(target->GetURI()) == 0);
		
	case TFDAVRESOURCELIST_FINDBYNAME:
		return (((TF_STRING_W *)pHint)->compare(target->GetName()) == 0);

	case TFDAVRESOURCELIST_FINDBYSERVERID:
		return (((TF_STRING_W *)pHint)->compare(target->GetServerID()) == 0);
	
	default:
		return false;
	}
}


