#include "TFIfHeader.h"

CTFIfHeader::CTFIfHeader(void)
{
}

CTFIfHeader::~CTFIfHeader(void)
{
}

void
CTFIfHeader::GetLockTokenIfHeader(LOCKLIST vLock, const XMLCh* pszURI, OI_STRING_A& strLockTokenIfHeader)
{
	strLockTokenIfHeader.erase();
	if (vLock.empty()) return;

	TF_STRING_A strURI = X(pszURI).UTF8();

	LOCKLIST::iterator	it = vLock.begin();
	for (; it != vLock.end(); )
	{
		TF_STRING_A strOneToken;

		CDavLock theLock = *it;
		strOneToken  = "<";
		strOneToken += Escape(strURI);
		strOneToken += ">";
		strOneToken += "(<";
		strOneToken += theLock.m_strToken;
		strOneToken += ">)";

		if (!strLockTokenIfHeader.empty())
			strOneToken += CRLF TAB;

		strLockTokenIfHeader += strOneToken;
		it++;
	}

}

void
CTFIfHeader::GetLockTokenIfHeader(const char* pszLockToken, const XMLCh* pszURI, OI_STRING_A& strLockTokenIfHeader)
{
	if (IS_EMPTY(pszLockToken)) return;

	OI_STRING_A	strOneToken;
	OI_STRING_A strURI = X(pszURI).UTF8();

	strOneToken  = "<";
	strOneToken	+= Escape(strURI);
	strOneToken += ">";
	strOneToken += "(<";
	strOneToken += pszLockToken;
	strOneToken += ">)";

	if (!strLockTokenIfHeader.empty())
		strOneToken += CRLF TAB;

	strLockTokenIfHeader += strOneToken.c_str();
}


