#include "TFLibWorkSessionManager.h"
#include "TFServerManager.h"
#include "TFCriticalSectionLocker.h"

CTFLibWorkSessionWorkerPtrVector	CTFLibWorkSessionManager::gs_vSession;		//< ワークセッション一覧
short								CTFLibWorkSessionManager::m_snSessionCounter = 1;
CTFCriticalSection					CTFLibWorkSessionManager::gs_cWsCtitSect;

CTFLibWorkSessionManager::CTFLibWorkSessionManager(void)
{
}

CTFLibWorkSessionManager::~CTFLibWorkSessionManager(void)
{
	Empty();
}

void
CTFLibWorkSessionManager::InitializeWorkSessionManager(void)
{
}

void
CTFLibWorkSessionManager::TerminateWorkSessionManager(void)
{
}

CTFLibWorkSessionWorker* 
CTFLibWorkSessionManager::GetSession(const TFXMLCh* pszServerID, TFHANDLE hProgress)
{
	OI_ASSERT(pszServerID);

	CTFCriticalSectionLocker	cLock(gs_cWsCtitSect);

	TF_STRING_W strServerID = pszServerID;

	CTFLibWorkSessionWorkerPtrVector::iterator	it = gs_vSession.end();
	for (;it != gs_vSession.begin();)
	{
		it--;
		CTFLibWorkSessionWorker* pWsWorker = *it;
		if (strServerID.compare(pWsWorker->GetServerID()) == 0 && pWsWorker->GetStatus() == TF_CONN_IDLE)
		{
			pWsWorker->AddRef();
			pWsWorker->SetStatus(TF_CONN_ESTABLISHED);
			pWsWorker->SetProgressHandle(hProgress);
			return pWsWorker;
		}
	}

	// 空いているセッションが存在しなかった場合は新たに作る
	CTFLibWorkSessionWorker *pNewSess = new CTFLibWorkSessionWorker;
	pNewSess->SetServerItem(GetServerManager().GetServerItem(strServerID.c_str()));
	if (!pNewSess->CreateSession()) return NULL;
	
	pNewSess->SetStatus(TF_CONN_ESTABLISHED);
	pNewSess->SetProgressHandle(hProgress);
	gs_vSession.push_back(pNewSess);

	return pNewSess;
}

/**
 *	利用できるワークセッションを管理しているクラスを取得する
 *	@param pItem	 CTFResourceItem*
 *	@param hProgress プログレスウィンドウハンドル
 *	@return CTFlibWorkSessonWorker*
 *
 */
CTFLibWorkSessionWorker*
CTFLibWorkSessionManager::GetSession(CTFResourceItem* pItem, TFHANDLE hProgress)
{
	return CTFLibWorkSessionManager::GetSession(pItem->GetServerID(), hProgress);
}

void 
CTFLibWorkSessionManager::CloseSession(CTFLibWorkSessionWorker* pSession, bool bPending)
{

	// セッションがNULLの場合はそのまま返す
	if (pSession == NULL) return;

	CTFCriticalSectionLocker	cLock(gs_cWsCtitSect);

	OI_ASSERT(pSession);
	pSession->SetStatus(TF_CONN_IDLE);

	TF_SIZE_T unID = pSession->m_unSessionID;

	CTFLibWorkSessionWorkerPtrVector::iterator	it = gs_vSession.begin();
	for (; it != gs_vSession.end();)
	{
		CTFLibWorkSessionWorker* pWsWorker = *it;
		if (pWsWorker->m_unSessionID == unID)
		{
			if (pWsWorker->Detach() == 0 && !bPending)
			{
				pWsWorker->Release();
				gs_vSession.erase(it);
			}
			break;
		}

		it++;
	}

}

void
CTFLibWorkSessionManager::Empty(void)
{

	CTFCriticalSectionLocker	cLock(gs_cWsCtitSect);

	if (!gs_vSession.empty())
	{
		delete gs_vSession.back();
		gs_vSession.pop_back();
	}
}
