#include <onion/PBCSMXml.h>
#include "TFLibWorkSessionWrapper.h"
#include "TFXmlBodyPaser.h"
#include "TFWsTransactionHandler.h"
#include "TFClientManager.h"
#include "TFResponseHeaderHandlerTFAnnounce.h"

CTFLibWorkSessionWrapper::CTFLibWorkSessionWrapper(void)
							:m_bUseLicense(false)
{
	m_pItemList = 0;
}

CTFLibWorkSessionWrapper::~CTFLibWorkSessionWrapper(void)
{
}

/**
 *	Onionハンドラ　OnResourceFound
 *
 *	@param	pReq	CDavRequest*
 *	@param	pNode	CDavResourceNode *
 *	@return void
 *
 */
void
CTFLibWorkSessionWrapper::OnResourceFound(CDavRequest* pReq, CDavResourceNode* pNode)
{
	CTFLibWorkSession::OnResourceFound(pReq, pNode);

	OI_ASSERT(m_pItemList);
	if( m_pItemList )
	{
		// パースを行う
		CTFXmlBodyPaser bp(m_strServerID.c_str());
		CTFDavResource* pItem = bp.Parse(pNode);

		if( pItem )
		{
			// 自分を作成したきっかけとなるURIを保持する
			pItem->SetTrigerURI(pReq->m_strURI);

			// ターゲットURIのリソースが含まれているかを調べる
			if( TF_STRING_W(pReq->m_strURI).compare( pItem->GetURI() ) == 0)
			{
				// 自分自身(アイテムリスト)にpItemの内容をコピーする
				// pItemがCTFDavResourceList以外であるので、アイテムリストの内容は書き換わらない
				m_pItemList->Import(*pItem);
				delete pItem;
			}
			else
			{
				bool bAddList = true;
				// 表示用のハンドラを呼ぶ
				CTFResourceProp* pPropItem = TFLIB_DYNAMIC_CAST(CTFResourceProp, pItem);
				if(pPropItem) bAddList = OnShowResource(pPropItem);

				// OnShowResourceの結果がfalseの場合はアイテムを削除して終了
				if (!bAddList)
				{
					delete pItem;
					return;
				}

				// pItemをリストに追加する。所有権はリストに移るのでdelete不要
				m_pItemList->AddItem(pItem);
			}
		}
	}
}

/**
 *	PROPFINDの結果を表示目的で使用する場合のハンドラ
 *
 *	@param pItem	CTFResourceProp*
 *	@return bool
 */
bool 
CTFLibWorkSessionWrapper::OnShowResource(CTFResourceProp* pItem)
{
	bool bResult = true;
	if (m_pTransHandler != NULL)
	{
		bResult = m_pTransHandler->OnShowResource(pItem);
	}

	return bResult;
}

/**
 *	サーチリクエストの戻り値を処理できるハンドラ
 *
 *	@param	pReq	CDavRequest*
 *	@param	pNode	DOMNode*
 *	@return	void
 */
void 
CTFLibWorkSessionWrapper::OnSearchResponse(CDavRequest* pReq, XNS(DOMNode)* pNode)
{
	CTFLibWorkSession::OnSearchResponse(pReq, pNode);

	OI_ASSERT(m_pItemList);
	if( m_pItemList )
	{
		CTFXmlBodyPaser bp(m_strServerID.c_str());
		CTFDavResource* pItem = bp.Parse(pNode);
		if( pItem )
		{
			/*
			 * Root Treeの戻り値は利用できるアイテムを制御する。
			 */
			CTFResourceTFRootTree* pRtItem = TFLIB_DYNAMIC_CAST(CTFResourceTFRootTree, pItem);
			if (pRtItem && 
				( m_pTransHandler->OnQueryAcceptItem( pRtItem->GetFolderType()) ) == false)
			{
				delete pItem;
				return;
			}

			bool bAddList=true;
			// 自分を作成したきっかけとなるURIを保持する
			pItem->SetTrigerURI(pReq->m_strURI);
			// 表示用のハンドラを呼ぶ
			CTFResourceProp* pPropItem = TFLIB_DYNAMIC_CAST(CTFResourceProp, pItem);
			if(pPropItem) bAddList = OnShowSearchResponse(pPropItem);
			// OnShowResourceの結果がfalseの場合はアイテムを削除して終了
			if (!bAddList)
			{
				delete pItem;
				return;
			}
			// pItemをリストに追加する。所有権はリストに移るのでdelete不要
			m_pItemList->AddItem(pItem);
		}
	}
}

/**
 *	サーチリクエストの結果を表示目的で使用する場合のハンドラ
 *
 *	@param pItem	CTFResourceProp*
 *	@return void
 */
bool 
CTFLibWorkSessionWrapper::OnShowSearchResponse(CTFResourceProp* pItem)
{
	return OnShowResource(pItem);
}

OI_RESULT
CTFLibWorkSessionWrapper::ProcessExtraHeader(CDavRequest* pReq, const char* pszName, OI_STRLIST_A& vecValues)
{
	OI_DEBUG("CTFLibWorkSessionWrapper::ProcessExtraHeader()\n");
	return OI_OK;
}

/**
 *	リクエスト生成時ハンドラ
 *	@param pReq		CDavRequest
 *	@return void
 *	(note)
 *	ここで、任意のヘッダーを追加できる
 *	このハンドラではCDavWorkSessionのメンバ変数に値を入れても効果がありません。
 *	やれることはヘッダの追加だけにしておいたほうがいいです。
 *
 */
void
CTFLibWorkSessionWrapper::OnCreateRequest(CDavRequest *pReq)
{
	OI_ASSERT(pReq);

	// リクエストに利用する言語種別を取得する
	TFLANG	enuLang = TF_LANG_UNKNOWN;
	m_pTransHandler->OnTransLangMode(enuLang);

	// AcceptLanguageの設定
	if (enuLang != TF_LANG_UNKNOWN)
	{
		CTFClientManager cClientMgr;
		pReq->AddRequestHeader(TF_HEADER_ACCEPTLANGUAGE, cClientMgr.GetAcceptLanguageString(enuLang));
	}

	// TF-Client-Infoの設定
	pReq->AddRequestHeader(TF_HEADER_TF_CLIENT_INFO, "mc11");

	// ライセンスヘッダが必要になった
	if (m_bUseLicense)
	{
		OI_STRING_A	strLicense;
		m_pTransHandler->OnRequestLicense(strLicense);
		OI_DEBUG("WARNING : LicenseCode is Empty!!!");

		if (strLicense.empty()) {
			pReq->AddRequestHeader(TF_HEADER_TF_AUTHORIZATION, strLicense.c_str());
		}
	}

	if (T_REQ_DELETE == pReq->GetMethod())
	{
		// 強制削除ヘッダが必要になるか？
		if (m_pTransHandler->GetFeature(CTFWsTransactionHandler::TF_TRANS_FEATURE_METHOD_DELETE_FORCE))
		{
			pReq->AddRequestHeader(TF_HEADER_TF_FORCE_DELETE, "T");
		}
	}

	// 追加ヘッダが必要かどうかを要求する
	TF_STRING_STRING_MAP	mapHeader;
	m_pTransHandler->OnRequestAddHeader(mapHeader);

	if (!mapHeader.empty())
	{
		TF_STRING_STRING_MAP::iterator it = mapHeader.begin();
		while(it != mapHeader.end())
		{
			pReq->AddRequestHeader(it->first.c_str(), it->second.c_str());
		}
	}
}

/**
 *	ヘッダ送信前に呼び出されるハンドラ
 */
void
CTFLibWorkSessionWrapper::OnPreSendRequest(CDavRequest* pReq)
{
	OI_DEBUG("CTFLibWorkSessionWrapper::OnPreSendRequest()\n");

	// このNewは削除不要です。（自動的に消去されます）
	pReq->AddHandler(new CTFResponseHeaderHandlerTFAnnounce(&m_cReceiver));

}

void
CTFLibWorkSessionWrapper::OnPreRecvResponse(CDavRequest* pReq)
{
	OI_DEBUG("CTFLibWorkSessionWrapper::OnPreRecvResponse()\n");
}

/**
 *	ヘッダ送信前に呼ばれるハンドラ
 */
void
CTFLibWorkSessionWrapper::OnPostSendRequest(CDavRequest* pReq)
{
	OI_DEBUG("CTFLibWorkSessionWrapper::OnPostSendRequest()\n");
	OI_ASSERT(pReq);
}

/**
 *	リクエスト送信後に呼ばれるハンドラ
 *
 */
void
CTFLibWorkSessionWrapper::OnPostRecvResponse(CDavRequest* pReq)
{
	OI_DEBUG("CTFLibWorkSessionWrapper::OnPostRecvResponse()\n");
}

bool
CTFLibWorkSessionWrapper::OnSendProgress(CDavRequest* pReq, OI_SIZE_T unProgress, OI_SIZE_T unTotal)
{
	bool bCanceled = false;

	if (m_pNotifyHandler)
	{
		switch(pReq->GetMethod())
		{
			// PUT / MKCOL
			case T_REQ_PUT:
			case T_REQ_MKCOL:
				bCanceled = !m_pNotifyHandler->OnUpdateProgressWindow(pReq->m_strURI, m_hProgress, unProgress, unTotal);
				break;

			default:
				break;
		}

	}

	return !bCanceled;
}

bool
CTFLibWorkSessionWrapper::OnReceiveProgress(CDavRequest* pReq, OI_SIZE_T unProgress, OI_SIZE_T unTotal, bool bCLength)
{
	bool bCanceled = false;

	if (m_pNotifyHandler)
	{
//		if (pReq->GetStatusCode() != 401) return !bCanceled;

		switch(pReq->GetMethod())
		{
			case T_REQ_GET:
				bCanceled = !m_pNotifyHandler->OnUpdateProgressWindow(pReq->m_strURI, m_hProgress, unProgress, unTotal);
				
			default:
				break;

		}
	}

	return !bCanceled;
}

void
CTFLibWorkSessionWrapper::OnDestroyRequest(CDavRequest* pReq)
{

}

/**
 * Onion DAV Method PROPFIND ラッパー
 * 
 * @param	pszURI		const TFXMLCh*
 * @param	enuDepth	OI_PFIND_DEPTH
 * @param	ppItem		CTFResourceProp**	アイテム（リスト）のオブジェクトを受け取るポインタ
 * @return OI_RESULT
 *
 */
OI_RESULT
CTFLibWorkSessionWrapper::DoTFPropfind(const TFXMLCh* pszURI, CTFResourceProp** ppItem, OI_PFIND_DEPTH enuDepth )
{
	OI_ASSERT(!m_pItemList);
	m_pItemList = new CTFDavResourceList();

	OI_RESULT oiResult = DoPropfind(pszURI, enuDepth);

	if( ppItem )
	{
		*ppItem = m_pItemList;
	}
	else
	{
		delete m_pItemList;
	}

	// PROPFINDは時に正常なのに空っぽのResponceがあるその場合はNotFoundとして処理
	if (m_pItemList == NULL) oiResult = OIDENOTFOUND;

	m_pItemList = 0;
	return oiResult;
}

OI_RESULT
CTFLibWorkSessionWrapper::DoTFPropfindCustom(const TFXMLCh*		pszURI,
											CTFResourceProp**	ppItem, 
											OI_PFIND_DEPTH		enuDepth,
											TFLIVEPROP			enuLive,
											TFLIVEPROPTF		enuLiveEx,
											TFDEADPROP			enuDead)
{
	OI_ASSERT(!m_pItemList);
	m_pItemList = new CTFDavResourceList();
	OI_RESULT oResult;

	const char* pszDepth;

	switch(enuDepth)
	{
		case D_PFIND_ZERO:
			pszDepth = "0";
			break;

		case D_PFIND_INFINITE:
			pszDepth = "infinity";
			break;

		case D_PFIND_ONE:
		default:
			pszDepth = "1";
			break;
	}

	CTFXmlBodyPropfind cXml;
	if (cXml.CreateBody(enuLive, enuLiveEx, enuDead))
	{
		CDavRequest	cReq;
		CPBCSMXml	csmXml(&cReq, OI_XML_CUTELEMENT);
		cReq.AddRequestHeader(OI_REQHDR_DEPTH, pszDepth);
		cReq.AddRequestHeader(OI_REQHDR_CONTENTTYPE, "text/xml");
		oResult = cReq.Create(this, T_REQ_PROPFIND, OI_METHOD_PROPFIND, pszURI);
		if (OI_OK == oResult)
			oResult = cReq.Dispatch(&cXml, &csmXml);

		if (ppItem)
		{
			*ppItem = m_pItemList;
		}
		else
		{
			delete m_pItemList;
		}
	}

	// PROPFINDは時に正常なのに空っぽのResponceがあるその場合はNotFoundとして処理
	if (m_pItemList == NULL) oResult = OIDENOTFOUND;

	m_pItemList = 0;

	return oResult;
}

/**
 * Onion DAV Method SEARCH ラッパー
 * 
 * @param	pszURI		const char*
 * @param	ppItem		CTFResourceProp**
 * @param	pXml		CRBPVDXmlSearch*
 * @return	OI_RESULT
 *
 */
OI_RESULT
CTFLibWorkSessionWrapper::DoTFSearch(const TFXMLCh *pszURI, CTFResourceProp** ppItem, CRBPVDXmlSearch *pXml)
{
	OI_ASSERT(!m_pItemList);
	m_pItemList = new CTFDavResourceList();

	OI_RESULT oiResult = DoSearch(pszURI, pXml);

	if( ppItem )
	{
		*ppItem = m_pItemList;
	}
	else
	{
		delete m_pItemList;
	}
	m_pItemList = 0;

	return oiResult;
}

OI_RESULT 
CTFLibWorkSessionWrapper::DoTFOptions(const TFXMLCh* pszURI, OI_HEADERMAP* pHeaders)
{
	OI_ASSERT(pszURI);

	OI_RESULT oResult = DoOptions(pszURI, pHeaders);

	return oResult;
}

OI_RESULT
CTFLibWorkSessionWrapper::DoTFMkcol(const TFXMLCh* pszURI, const char* pszIfHeader, CRequestBodyProvider* pBodyProvider)
{
	OI_ASSERT(pszURI);

	OI_RESULT oResult = DoMkcol(pszURI, pszIfHeader, pBodyProvider);

	return oResult;
}

OI_RESULT
CTFLibWorkSessionWrapper::DoTFLock(const TFXMLCh* pszURI, CDavLock *pLock, const char *pszIfHeader)
{
	OI_ASSERT(pszURI);
	
	OI_RESULT oResult = DoLock(pszURI, pLock, pszIfHeader);

	return oResult;
}

OI_RESULT
CTFLibWorkSessionWrapper::DoTFUnlock(const TFXMLCh* pszURI, const char *pszLockToken)
{
	OI_ASSERT(pszURI);

	OI_RESULT oResult = DoUnlock(pszURI, pszLockToken);

	return oResult;
}

/**
 *	Onion DAV Method GET ラッパー
 *
 *	@param pszURI			const XMLCh*
 *	@param pszLocalPath	const char*
 *	@param	pRange			OICRANGE 
 *	@return oResult		OI_RESULT
 */
OI_RESULT
CTFLibWorkSessionWrapper::DoTFGet(const TFXMLCh *pszURI, const char *pszLocalPath, OICRANGE* pRange)
{
	OI_ASSERT(pszURI);

	OI_RESULT oResult = DoGet(pszURI, pszLocalPath, pRange);

	return oResult;
}

OI_RESULT 
CTFLibWorkSessionWrapper::DoTFGet(const TFXMLCh* pszURI, int hFile, OICRANGE* pRange)
{
	OI_ASSERT(pszURI);

	OI_RESULT oResult = DoGet(pszURI, hFile, pRange);

	return oResult;
}

OI_RESULT 
CTFLibWorkSessionWrapper::DoTFPut(const TFXMLCh* pszURI, const char* pszLocalPath,
				  const char *pszIfHeader, const char *pszContentType)
{
	OI_ASSERT(pszURI);

	OI_RESULT oResult = DoPut(pszURI, pszLocalPath, pszIfHeader, pszContentType);

	return oResult;
							  
}

OI_RESULT
CTFLibWorkSessionWrapper::DoTFPut(const TFXMLCh* pszURI, int hFile, const char* pszIfHeader, const char* pszContentType)
{
	OI_ASSERT(pszURI);

	OI_RESULT oResult = DoPut(pszURI, hFile, pszIfHeader, pszContentType);

	return oResult;
}

/**
 *	Onion DAV Method DELETE ラッパー
 *
 *	@param pszURI			const XMLCh*
 *	@param pszIfHeader	const char*
 *	@return oResult		OI_RESULT
 */
OI_RESULT
CTFLibWorkSessionWrapper::DoTFDelete(const TFXMLCh* pszURI, const char* pszIfHeader)
{
	OI_ASSERT(pszURI);

	OI_RESULT oResult = DoDelete(pszURI, pszIfHeader);

	return oResult;
}

OI_RESULT 
CTFLibWorkSessionWrapper::DoTFMove(const TFXMLCh* pszSrc, const TFXMLCh* pszDest, CRBPVDXmlMove *pXml, bool bOverwrite, const char *pszIfHeader)
{
	OI_ASSERT(pszSrc);
	OI_ASSERT(pszDest);

	OI_RESULT oResult = DoMove(pszSrc, pszDest, pXml, bOverwrite, pszIfHeader);

	return oResult;
}

OI_RESULT
CTFLibWorkSessionWrapper::DoTFCopy(const TFXMLCh* pszSrc, const TFXMLCh* pszDest, CRBPVDXmlCopy *pXml, bool bOverwrite, const char *pszIfHeader)
{
	OI_ASSERT(pszSrc);
	OI_ASSERT(pszDest);

	OI_RESULT oResult = DoCopy(pszSrc, pszDest, pXml, bOverwrite, pszIfHeader);

	return oResult;
}

/**
 *	Onion DAV Method PROPPATCH ラッパー
 *
 *	@param pszURI			const XMLCh*
 *	@param	pXml			CRBPVDXProppatch*
 *	@param pszIfHeader	const char*
 *	@return oResult		OI_RESULT
 */
OI_RESULT
CTFLibWorkSessionWrapper::DoTFProppatch(const TFXMLCh* pszURI, CRBPVDXmlProppatch* pXml, const char* pszIfHeader)
{
	OI_ASSERT(pszURI);

	OI_RESULT oResult = DoProppatch(pszURI, pXml, pszIfHeader);

	return oResult;
}

/**
 *	WorkSession内でライセンスを必要としたい場合TRUEとする
 *	@param	bUseLicense		bool
 *	@return void
 */
void 
CTFLibWorkSessionWrapper::SetRequestLicense(bool bUseLicense)
{
	m_bUseLicense = bUseLicense;
}


