#include "TFLocalFileItem.h"
#include "TFLibPublic.h"
#include "TFUtils.h"

#ifdef _DEBUG
	static int gs_nLocalFileCnt = 0;
	#define ADD_LOCALFILEITEM	gs_nLocalFileCnt++; TF_DEBUG("CTFLocalFileItem::gs_nLocalFileCnt: %d\n", gs_nLocalFileCnt)
	#define DEL_LOCALFILEITEM	gs_nLocalFileCnt--; TF_DEBUG("CTFLocalFileItem::gs_nLocalFileCnt: %d\n", gs_nLocalFileCnt)
#else
	#define ADD_LOCALFILEITEM
	#define DEL_LOCALFILEITEM
#endif

TFLIB_IMPLEMENT_CLASS(CTFLocalFileItem,"CTFLocalFileItem")

CTFLocalFileItem::CTFLocalFileItem(void)
{
//	ADD_LOCALFILEITEM;

	m_unAttr = 0;
	m_unSize = 0;
	m_enuFolderType = TF_FOLDER_TYPE_NOTFOLDER;
	m_strContentType.erase();

	TFLIB_CONSTRUCT_CLASS(CTFLocalFileItem);

}

CTFLocalFileItem::~CTFLocalFileItem(void)
{
//	DEL_LOCALFILEITEM;
}

void CTFLocalFileItem::Import(const CTFObject& source)
{
	TFLIB_PREPARE_IMPORT(CTFLocalFileItem, CTFObject, source, psource);

	m_unAttr = psource->m_unAttr;
	m_unSize = psource->m_unSize;
	m_enuFolderType = psource->m_enuFolderType;
	m_strContentType = psource->m_strContentType;
}

int
CTFLocalFileItem::SetPath(int iFlags, void* pBuffer, int iSize)
{
	return 0;
}

int
CTFLocalFileItem::GetPath(int iFlags, void** ppBuffer, int* piSize) const
{
	return 0;
}

TF_SIZE_T 
CTFLocalFileItem::GetSize(void) const
{
	return m_unSize;
}

void
CTFLocalFileItem::SetSize(TF_SIZE_T nSize)
{
	m_unSize = nSize;
}

bool
CTFLocalFileItem::isFolder(void)
{
	bool bResult = false;
	if (m_unAttr & TF_FILE_ATTRIBUTE_DIRECTORY)
	{
		bResult = true;
	}

	return bResult;
}

bool
CTFLocalFileItem::isSymLink(void)
{
	bool bResult = false;

#ifdef _WIN32
	return false;
#else
	if (m_unAttr & TF_FILE_ATTRIBUTE_LINK)
	{
		bResult = true;
	}
#endif

	return bResult;
}

bool
CTFLocalFileItem::isTemporary(void)
{
	if (m_enuFolderType == TF_FOLDER_TYPE_TEMP)
	{
		return true;
	}

	// TODO: アイテムの一時ファイルチェックもいれてね
	return false;
}

void
CTFLocalFileItem::SetFolderType(TF_FOLDER_TYPE enuType)
{
	m_enuFolderType = enuType;
}

TF_FOLDER_TYPE
CTFLocalFileItem::GetFolderType(void)
{
	return m_enuFolderType;
}

TF_SIZE_T
CTFLocalFileItem::GetAttributes(void)
{
	return m_unAttr;
}

void
CTFLocalFileItem::SetAttributes(TF_SIZE_T nAttribute)
{
	m_unAttr = nAttribute;
}

int
CTFLocalFileItem::GetFD(void)
{
	return m_nFD;
}

void 
CTFLocalFileItem::SetFD(int nFD)
{
	m_nFD = nFD;
}


