#ifndef _WIN32
#include "config.h"
#endif

#include "TFMemory.h"

#ifdef _WIN32
#include <windows.h>

#else /* posix */

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#endif

CTFMemory::CTFMemory(void)
{
}

CTFMemory::~CTFMemory(void)
{
}

void*
CTFMemory::TFMalloc(int nsize)
{

#ifdef _WIN32
	return (void*)LocalAlloc(0, nsize);
#else
	return malloc(nsize);
#endif


	return NULL;
}

void
CTFMemory::TFFree(void* nPtr)
{

	if (nPtr != NULL)
	{
#ifdef _WIN32
		LocalFree(nPtr);
#else
		free(nPtr);
#endif
	}
}


