/**
 *	Copyrigth(c) 2004 Pertner Co., Ltd. TeamFile Team
 *
 *	ファイル名	:	TfObject.cpp
 *  クラス名		:	CTFObject
 *	継承			:
 *
 *	機能　		:	クラスの正体を動的に判断し、ダウンキャスト検証機能を提供する
 *
 *
 */

#include "TFObject.h"

TFLIB_IMPLEMENT_CLASS(CTFObject,"CTFObject")


/**
 *	コンストラクタ
 *
 */
CTFObject::CTFObject(void)
{
	TFLIB_CONSTRUCT_CLASS(CTFObject);
}

/**
 *	デストラクタ
 *
 */
CTFObject::~CTFObject(void)
{
}

/**
 *	オブジェクトの中身を取り込む。
 *	派生先のクラスはこのメソッドを実装し、メンバー変数のコピー処理を入れること
 *
 *	@param	source		取り込み元のオブジェクト参照
 */
void CTFObject::Import(const CTFObject& source)
{
	// CTFObjectでは、特にコピーするものは無い
	// CTFObjectは基底クラスなので、これより上位のImportメソッドも呼ぶ必要はない
}

/**
 *	クラス情報を登録する
 *
 *	@param	pinfo	対象クラスのクラス情報オブジェクトのポインタ(&TFLIB_GET_CLASSINFO(class))
 */
void CTFObject::RegisterClassInfo(CTFClassInfo* pinfo)
{
	m_cClassInfoPtrList.push_back(pinfo);
}

/**
 *	指定されたクラスから派生されたものかを調べる
 *
 *	ダウンキャストを行う場合、この関数を使ってキャストの正当性をチェックしてください。
 *	ただし、この関数はCTFObjectの派生クラスでないと使用できません。
 *
 *	@param	pinfo	対象クラスのクラス情報オブジェクトのポインタ(&TFLIB_GET_CLASSINFO(class))
 *	@return	bool	true:指定クラスを含んでいる、false:指定クラスを含んでいない
 */
bool CTFObject::IsKindOf(CTFClassInfo* pinfo)
{
	CTFClassInfoPtrList::iterator p;

	// クラス情報を「下位クラスから」探す
	// ダウンキャストの検証が目的なので、下位クラスから探したほうが早く見つかる
	p = m_cClassInfoPtrList.end();
	while( p != m_cClassInfoPtrList.begin() )
	{
		p--;
		if( *p == pinfo ) return true;
	}

	return false;
}

/**
 *	クラス名を得る
 *
 *	@return	const char*	クラス名。ただし、デバッグ時のみ取得可能
 */
const char* CTFObject::GetTFClassName()
{
	if( m_cClassInfoPtrList.empty() ) return "";
	return m_cClassInfoPtrList.back()->m_szClassName;
}

/**
 *	オブジェクトを生成する
 *
 *	@return	CTFObject*	オブジェクト
 */
CTFObject* CTFObject::CreateDerivedObject()
{
	if( m_cClassInfoPtrList.empty() ) return 0;
	return m_cClassInfoPtrList.back()->CreateObject();
}

/**
 *	オブジェクトの複製を生成する
 *
 *	@return	CTFObject*	オブジェクト
 */
CTFObject* CTFObject::Clone()
{
	if( !m_cClassInfoPtrList.empty() )
	{
		// 生成を行ったクラスと同じクラスのオブジェクトを生成する
		CTFObject* pNewObj = CreateDerivedObject();
		if( pNewObj )
		{
			// メンバー変数のコピーを行う
			// 下位クラスのメンバーも自動的にコピーされる
			*pNewObj = *this;
			return pNewObj;
		}
	}
	return 0;
}
