#include "TFRID.h"
#include "TFResourceTFRootTree.h"
#include "TFResourceProp.h"
#include "TFServerResource.h"
#include "TFDavResource.h"

CTFRID::CTFRID(void)
{
}

CTFRID::~CTFRID(void)
{
}

CTFRID&
CTFRID::operator =(const CTFRID& source)
{
	if (&source != this)
	{
		m_enuType		= source.m_enuType;
		m_strURI		= source.m_strURI;
		m_strServerID	= source.m_strServerID;
	}

	return *this;
}

bool
CTFRID::operator ==(const CTFRID& source)
{
	if (source.m_enuType != m_enuType)
		return false;

	if (source.m_strServerID.compare(m_strServerID) != 0)
		return false;

	if (source.m_strURI.compare(m_strURI) != 0)
		return false;

	return true;
}

/**
 *	ResourceItemからRIDを生成する
 *
 *	@param	pItem		CTFResourceItem*
 *	@param	vID			TFRID&
 *
 */
void
CTFRID::SetItem(CTFResourceItem* pItem)
{
	OI_ASSERT(pItem);
	TFITEMTYPE	enuItem = TFITEM_UNKNOWN;

	CTFDavResource*	pDavItem = TFLIB_DYNAMIC_CAST(CTFDavResource, pItem);
	if (pDavItem)
	{
		/*
		*	アイテムのタイプを調べる
		*/
		m_enuType		= getItemType(pItem);

		m_strServerID	= pItem->GetServerID();
		m_strURI		= pDavItem->GetURI();
	}
}


const TFXMLCh*
CTFRID::GetServerID(void)
{
	return m_strServerID.c_str();
}

bool
CTFRID::IsFolder(void)
{
	if (m_strURI.empty()) return false;
	return ((*(m_strURI.end()-1)) == '/');
}


TFITEMTYPE
CTFRID::getItemType(CTFResourceItem* pItem)
{
	TFITEMTYPE enuItem = TFITEM_UNKNOWN;

	CTFResourceTFRootTree* pRootItem = TFLIB_DYNAMIC_CAST(CTFResourceTFRootTree, pItem);
	if (pRootItem)
	{
		enuItem =  pRootItem->GetFolderType();
	}
	else {
		CTFResourceProp* pPropItem = TFLIB_DYNAMIC_CAST(CTFResourceProp, pItem);
		if (pPropItem)
		{
			enuItem = (pPropItem->IsCollection()) ? TFITEM_FOLDER : TFITEM_FILE;	
		}
		else {
			CTFServerResource* pSvrItem = TFLIB_DYNAMIC_CAST(CTFServerResource, pItem);
			if (pSvrItem)
			{
				enuItem = TFITEM_SERVER;
			}
			else {
				OI_DEBUG("Item Type UnKnown .... ");
			}
		}
	}

	return enuItem;
}

TFITEMTYPE
CTFRID::GetType(void)
{
	return m_enuType;
}


