#include "TFRegex.h"

CTFRegex::CTFRegex(void)
{
	m_vPCRE.empty();
}

CTFRegex::~CTFRegex(void)
{
#ifdef HAVE_LIBPCRE
	if (m_vPCRE.size() > 0)
	{
		std::vector<pcre*>::iterator it = m_vPCRE.begin();
		while(it != m_vPCRE.end())
		{
			pcre_free(*it);
			it++;
		}
	}
#endif
}

bool
CTFRegex::IsSupported(void)
{
#ifdef HAVE_LIBPCRE
	return true;
#else
	return false;
#endif
}

int
CTFRegex::AddPattern(const char* pattern, int nOptions)
{
	if (pattern == NULL) return 0;

#ifdef HAVE_LIBPCRE

	const char* pszError;
	int nCode;
	pcre* p = NULL;
	p = pcre_compile(pattern, nOptions, &pszError, &nCode, 0);
	
	if (p != NULL) m_vPCRE.push_back(p);

	return (p != NULL);

#endif
	return 0;
}

int
CTFRegex::Search(const char* pszData)
{
	int rc = -1;

#ifdef HAVE_LIBPCRE

	if (pszData == NULL) return -1;

	if (m_vPCRE.size() > 0)
	{
		std::vector<pcre*>::iterator it = m_vPCRE.begin();

		int i = 0;
		while(it != m_vPCRE.end())
		{
			rc = pcre_exec( *it,
							NULL,
							pszData,
							(int)strlen(pszData),
							0,
							0,
							NULL,
							0);

			if (rc == 0) return i;
			it++;
			i++;
		}
	}
#endif

	return rc;
}

