#include "TFResourceItem.h"
#include "TFResourceProp.h"
#include "TFServerResource.h"
#include "TFServerManager.h"

TFLIB_IMPLEMENT_CLASS(CTFResourceItem,"CTFResourceItem")
CTFClassInfo CTFResourceItem::m_cClass2CTFResourceItem;
CTFResourceItem::CTFResourceItem(void):
				m_enuType(TFITEM_UNKNOWN)
{
	TFLIB_CONSTRUCT_CLASS(CTFResourceItem);
	// このオブジェクトの作成時刻を設定する
	m_tCreateTime = time(NULL);
}

CTFResourceItem::~CTFResourceItem(void)
{
}


bool
CTFResourceItem::operator ==(const CTFResourceItem& source)
{
	// TODO: なにか比較しなさい
	return true;
}

void CTFResourceItem::Import(const CTFObject& source)
{
	TFLIB_PREPARE_IMPORT(CTFResourceItem, CTFObject, source, psource);

	m_enuType		= psource->m_enuType;
	m_strName		= psource->m_strName;
	m_strServerID	= psource->m_strServerID;
	m_tCreateTime	= psource->m_tCreateTime;

}

const TFXMLCh*
CTFResourceItem::GetName(void)
{
	return m_strName.c_str();
}

void
CTFResourceItem::SetName(const TFXMLCh* strName)
{
	m_strName = strName;
}

const TFXMLCh*
CTFResourceItem::GetRootURI(void)
{
	CTFServerResource* pSvrItem = GetServerManager().GetServerItem(m_strServerID.c_str());
	if (pSvrItem)
	{
		return pSvrItem->GetURI();
	}

	return NULL;
}

const TFXMLCh* 
CTFResourceItem::GetROOTURL(void)
{
	CTFServerResource* pSvrItem = GetServerManager().GetServerItem(m_strServerID.c_str());
	if (pSvrItem)
	{
		return pSvrItem->GetURL();
	}

	return NULL;
}

/**
 *	このリソースオブジェクトのサーバーIDを得る
 *
 *	@return	X	サーバーID
 *
 */
const TFXMLCh*
CTFResourceItem::GetServerID(void)
{
	return m_strServerID.c_str();
}

void
CTFResourceItem::SetServerID(const TFXMLCh* pszServerID)
{
	m_strServerID = pszServerID;
}

/**
 *	指定したサーバーIDがこのリソースのサーバーIDと同じであるかを調べる
 *
 *	@param	pszURI	const TFXMLCh*	サーバーID
 *	@return	bool				サーバーIDが同じであればtrue
 *
 */
bool
CTFResourceItem::IsServerID(const TFXMLCh* pszServerID)
{
	return (m_strServerID.compare(pszServerID) == 0);
}

TFITEMTYPE 
CTFResourceItem::GetType(void)
{
	return m_enuType;
}

/**
 *	リソースオブジェクトが作成された時刻を得る
 *
 *	@return	time_t	作成時刻
 *
 */
time_t
CTFResourceItem::GetItemCreateTime(void)
{
	return m_tCreateTime;
}


