#include "TFResourceProp.h"

TFLIB_IMPLEMENT_CLASS(CTFResourceProp, "CTFResourceProp")

CTFResourceProp::CTFResourceProp(void)
:m_iContentLength(0),
 m_tCreationDate(0),
 m_tLastmodified(0),
 m_bNullResource(false),
 m_strContentLanguage(C2W("")),
 m_strContentType(C2W("")),
 m_strDisplayName(C2W("")),
 m_strEtag(C2W(""))
{
	TFLIB_CONSTRUCT_CLASS(CTFResourceProp);
}

CTFResourceProp::~CTFResourceProp(void)
{
}

void
CTFResourceProp::Import(const CTFObject& source)
{
	TFLIB_PREPARE_IMPORT(CTFResourceProp,CTFDavResource,source,psource);

	m_enuResourceType		= psource->m_enuResourceType;
	m_iContentLength		= psource->m_iContentLength;
	m_strContentLanguage	= psource->m_strContentLanguage;
	m_strContentType		= psource->m_strContentType;
	m_strDisplayName		= psource->m_strDisplayName;
	m_strEtag				= psource->m_strEtag;
	m_tCreationDate			= psource->m_tCreationDate;
	m_tLastmodified			= psource->m_tLastmodified;
	m_bNullResource			= psource->m_bNullResource;
	m_vecLocklist			= psource->m_vecLocklist;		// CDavLockクラスがベースなので、そのまま=でコピーしても問題無し
}

void
CTFResourceProp::SetCreationDate(time_t time)
{
	m_tCreationDate = time;
}

void
CTFResourceProp::SetDisplayName(const TFXMLCh* pszName)
{
	m_strDisplayName = pszName;
}

void
CTFResourceProp::SetContentLanguage(const TFXMLCh* pszLang)
{
	m_strContentLanguage = pszLang;
}

void
CTFResourceProp::SetContentLength(TF_SIZE_T len)
{
	m_iContentLength = len;
}

void
CTFResourceProp::SetContentType(const TFXMLCh* pszType)
{

	m_strContentType = pszType;

	if (m_strContentType.compare(X(TF_CNTTYPE_TRASH)) == 0)
		m_enuType = TFITEM_TRASH_FOLDER;
}

void
CTFResourceProp::SetEtag(const TFXMLCh* pszEtag)
{
	m_strEtag = pszEtag;
}

void
CTFResourceProp::SetLastModified(time_t time)
{
	m_tLastmodified = time;
}

void
CTFResourceProp::SetResourceType(OI_RES_TYPE enuType)
{
	m_enuResourceType = enuType;
	switch(enuType)
	{
		case T_RES_COLLECTION:
			if (m_enuType == TFITEM_UNKNOWN) m_enuType = TFITEM_FOLDER;
			break;
		default:
			m_enuType = TFITEM_FILE;
	}
}

void 
CTFResourceProp::SetLock(CDavLock *cLock)
{
	m_vecLocklist.push_back(*cLock);
}

time_t
CTFResourceProp::GetCreationDate(void)
{
	return m_tCreationDate;
}

const TFXMLCh*
CTFResourceProp::GetDisplayName(void)
{
	return m_strDisplayName.c_str();
}

const TFXMLCh*
CTFResourceProp::GetContentLanguage(void)
{
	return m_strContentLanguage.c_str();
}

TF_SIZE_T 
CTFResourceProp::GetContentLength(void)
{
	return m_iContentLength;
}

const TFXMLCh*
CTFResourceProp::GetContentType(void)
{
	return m_strContentType.c_str();
}

const TFXMLCh*
CTFResourceProp::GetEtag(void)
{
	return m_strEtag.c_str();
}

time_t
CTFResourceProp::GetLastModified(void)
{
	return m_tLastmodified;
}

OI_RES_TYPE 
CTFResourceProp::GetResourceType(void)
{
	return m_enuResourceType;
}

bool
CTFResourceProp::IsCollection(void)
{
	return (m_enuResourceType == T_RES_COLLECTION);
}

bool
CTFResourceProp::IsNullResource(void)
{
	return m_bNullResource;
}

LOCKLIST
CTFResourceProp::GetLocklist(void)
{
	return m_vecLocklist;
}

