#include "TFResourcePropTF.h"
#include "TFLibDefinition.h"
#include "TFUtils.h"

#ifdef _DEBUG
	static int gs_nTFResourcePropTF = 0;
	#define ADD_RESOURCEPROPTF	gs_nTFResourcePropTF++; OI_DEBUG("CTFResourcePropTF::gs_nTFResourcePropTF:- add -: %d\n", gs_nTFResourcePropTF)
	#define DEL_RESOURCEPROPTF	gs_nTFResourcePropTF--; OI_DEBUG("CTFResourcePropTF::gs_nTFResourcePropTF:- del - %d\n", gs_nTFResourcePropTF)
#else
	#define ADD_RESOURCEPROPTF
	#define DEL_RESOURCEPROPTF
#endif

TFLIB_IMPLEMENT_CLASS(CTFResourcePropTF,"CTFResourcePropTF")

CTFResourcePropTF::CTFResourcePropTF(void):
					    m_bMailWatchOwner(false)
					   ,m_iMailWatchMethod(TF_DAV_UNKNOWN)
					   ,m_tDeletion(0)
					   ,m_nResState(TF_RES_STATE_NONE)
					   ,m_nUserPrivilege(TF_USER_PRIV_NONE)
					   ,m_strCreator(C2W(""))
					   ,m_strLastModifire(C2W(""))
{
	ADD_RESOURCEPROPTF;
	TFLIB_CONSTRUCT_CLASS(CTFResourcePropTF);
}

CTFResourcePropTF::~CTFResourcePropTF(void)
{
	DEL_RESOURCEPROPTF;
}

void CTFResourcePropTF::Import(const CTFObject& source)
{
	TFLIB_PREPARE_IMPORT(CTFResourcePropTF,CTFResourceProp,source,psource);

	m_bMailWatchOwner	= psource->m_bMailWatchOwner;
	m_iMailWatchMethod	= psource->m_iMailWatchMethod;
	m_strCreator		= psource->m_strCreator;
	m_strLastModifire	= psource->m_strLastModifire;
	m_strDeleter		= psource->m_strDeleter;
	m_tDeletion			= psource->m_tDeletion;
	m_nResState			= psource->m_nResState;
	m_nUserPrivilege	= psource->m_nUserPrivilege;
}


void
CTFResourcePropTF::SetCreator(const TFXMLCh* pszCreator)
{
	m_strCreator = pszCreator;
}

void
CTFResourcePropTF::SetLastModifire(const TFXMLCh* pszModifire)
{
	m_strLastModifire = pszModifire;
}

void
CTFResourcePropTF::SetMailWatchMethod(const TFXMLCh* pszMethod)
{
	m_iMailWatchMethod = ParseMailWatchString(X(pszMethod));
}

void 
CTFResourcePropTF::SetMailWatchOwner(bool bOwner)
{
	m_bMailWatchOwner = bOwner;
}

const TFXMLCh*
CTFResourcePropTF::GetCreator(void)
{
	return m_strCreator.c_str();
}

const TFXMLCh*
CTFResourcePropTF::GetLastModifire(void)
{
	return m_strLastModifire.c_str();
}

void 
CTFResourcePropTF::SetDeleter(const TFXMLCh* pszDeleter)
{
	m_strDeleter = pszDeleter;
}

void 
CTFResourcePropTF::SetDeletion(time_t tDeletion)
{
	m_tDeletion = tDeletion;
}

void 
CTFResourcePropTF::SetResourceState(TFRESOURCESTATE nResState)
{
	m_nResState = nResState;
}

void 
CTFResourcePropTF::SetUserPrivilegeGrantSet(TFUSERPRIV nPriv)
{
	m_nUserPrivilege = nPriv;
}

bool
CTFResourcePropTF::IsMailWatch(void)
{
	return (m_iMailWatchMethod != TF_DAV_UNKNOWN);
}

bool 
CTFResourcePropTF::IsMailWatchOwner(void)
{
	return m_bMailWatchOwner;
}

const TFXMLCh* 
CTFResourcePropTF::GetDeleter(void)
{
	return m_strDeleter.c_str();
}

time_t
CTFResourcePropTF::GetDeletion(void)
{
	return m_tDeletion;
}

TFRESOURCESTATE
CTFResourcePropTF::GetResourceState(void)
{
	return m_nResState;
}

TFUSERPRIV
CTFResourcePropTF::GetUserPrivilegeGrantSet(void)
{
	return m_nUserPrivilege;
}
