#include "TFResourcePropTFGroup.h"
#include "TFUtils.h"
#include "TFLibPublic.h"

TFLIB_IMPLEMENT_CLASS(CTFResourcePropTFGroup,"CTFResourcePropTFGroup")

CTFResourcePropTFGroup::CTFResourcePropTFGroup(void)
:m_unMailWatch(TF_DAV_UNKNOWN)
{
	TFLIB_CONSTRUCT_CLASS(CTFResourcePropTFGroup);
	m_enuType = TFITEM_MNG_GRP;
	m_nConstraints = TF_GROUPCONSTRAINTS_NONE;
	m_nGroupState = TF_GROUPSTATE_NONE;
}

CTFResourcePropTFGroup::~CTFResourcePropTFGroup(void)
{
}

void CTFResourcePropTFGroup::Import(const CTFObject& source)
{
	TFLIB_PREPARE_IMPORT(CTFResourcePropTFGroup, CTFResourceProp,source,psource);

	m_strID			= psource->m_strID;
	m_strComment	= psource->m_strComment;
	m_unMailWatch	= psource->m_unMailWatch;

	m_nConstraints	= psource->m_nConstraints;
	m_nGroupState	= psource->m_nGroupState;
}

void 
CTFResourcePropTFGroup::SetID(const TFXMLCh* pszID)
{
	m_strID = pszID;
}

void
CTFResourcePropTFGroup::SetComment(const TFXMLCh* pszComment)
{
	m_strComment = pszComment;
}

void
CTFResourcePropTFGroup::SetMailWatch(const TFXMLCh* pszMailWatch)
{
	m_unMailWatch = ParseMailWatchString(X(pszMailWatch));
}

void
CTFResourcePropTFGroup::SetGroupCollectionUri(const TFXMLCh* pszUri)
{
	m_strGroupColUri = pszUri;
}

const TFXMLCh*
CTFResourcePropTFGroup::GetID(void)
{
	return m_strID.c_str();
}

const TFXMLCh*
CTFResourcePropTFGroup::GetComment(void)
{
	return m_strComment.c_str();
}

int
CTFResourcePropTFGroup::GetGrpMailWatch(void)
{
	return m_unMailWatch;
}

const TFXMLCh* 
CTFResourcePropTFGroup::GetGroupCollectionUri(void)
{
	return m_strGroupColUri.c_str();
}

void
CTFResourcePropTFGroup::SetGroupConstraints(int nConstraints)
{
	m_nConstraints = nConstraints;
}

int
CTFResourcePropTFGroup::GetGroupConstraints(void)
{
	return m_nConstraints;
}

const TFXMLCh* 
CTFResourcePropTFGroup::GetGroupConstraintsString(void)
{
	m_strtmp.empty();
	for(int i=0; TF_GROUP_CONSTRAINTS_TABLE[i].dwConstraints != TF_GROUPCONSTRAINTS_NONE; i++)
	{
		if (m_nConstraints & TF_GROUP_CONSTRAINTS_TABLE[i].dwConstraints)
		{
			m_strtmp += C2W(TF_GROUP_CONSTRAINTS_TABLE[i].szTagName);
			m_strtmp += C2W(" ");
		}
	}

	return m_strtmp.c_str();
}

void
CTFResourcePropTFGroup::SetGroupState(int nState)
{
	m_nGroupState = nState;
}

int 
CTFResourcePropTFGroup::GetGroupState(void)
{
	return m_nGroupState;
}

void 
CTFResourcePropTFGroup::SetGroupOwnerName(const TFXMLCh* pszName)
{
	m_strOwnerName = pszName;
}

void 
CTFResourcePropTFGroup::SetGroupOwnerID(const TFXMLCh* pszID)
{
	m_strOwnerID = pszID;
}

const TFXMLCh*
CTFResourcePropTFGroup::GetGroupOwnerName(void)
{
	return m_strOwnerName.c_str();
}

const TFXMLCh*
CTFResourcePropTFGroup::GetGroupOwnerID(void)
{
	return m_strOwnerID.c_str();
}

void 
CTFResourcePropTFGroup::SetChildCount(const TFXMLCh* pszChildCount)
{
	m_strChildCount = pszChildCount;
}

TF_SIZE_T
CTFResourcePropTFGroup::GetChildCount(void)
{
	char* pchPos = NULL;

	m_i64tmp = OI_STRTOUL(OI_STRING_A(X(m_strChildCount.c_str())).c_str(), &pchPos, 0);

	return m_i64tmp;

}

