#include "TFResourcePropTFMsg.h"

TFLIB_IMPLEMENT_CLASS(CTFResourcePropTFMsg,"CTFResourcePropTFMsg")

CTFResourcePropTFMsg::CTFResourcePropTFMsg(void):
m_bActive(false)
{
	TFLIB_CONSTRUCT_CLASS(CTFResourcePropTFMsg);
	m_enuType = TFITEM_MNG_MSG;
}

CTFResourcePropTFMsg::~CTFResourcePropTFMsg(void)
{
}

void CTFResourcePropTFMsg::Import(const CTFObject& source)
{
	TFLIB_PREPARE_IMPORT(CTFResourcePropTFMsg, CTFResourceProp,source,psource);

	m_strMSGID	= psource->m_strMSGID;
	m_strMsgTxt	= psource->m_strMsgTxt;
	m_bActive	= psource->m_bActive;
}

void 
CTFResourcePropTFMsg::SetMsgID(const TFXMLCh* pszID)
{
	m_strMSGID = pszID;
}

void
CTFResourcePropTFMsg::SetMsg(const TFXMLCh* pszMsg)
{
	m_strMsgTxt = pszMsg;
}

void
CTFResourcePropTFMsg::SetActiveFlag(bool bActive)
{
	m_bActive = bActive;
}

const TFXMLCh*
CTFResourcePropTFMsg::GetID(void)
{
	return m_strMSGID.c_str();
}

const TFXMLCh*
CTFResourcePropTFMsg::GetMsg(void)
{
	return m_strMsgTxt.c_str();
}

bool
CTFResourcePropTFMsg::GetActiveFlag(void)
{
	return m_bActive;
}

