#include "TFResourcePropTFUpdate.h"

TFLIB_IMPLEMENT_CLASS(CTFResourcePropTFUpdate,"CTFResourcePropTFUpdate")

CTFResourcePropTFUpdate::CTFResourcePropTFUpdate(void)
{
	TFLIB_CONSTRUCT_CLASS(CTFResourcePropTFUpdate);
	m_enuType = TFITEM_MNG_CLIENT;
}

CTFResourcePropTFUpdate::~CTFResourcePropTFUpdate(void)
{
}

void CTFResourcePropTFUpdate::Import(const CTFObject& source)
{
	TFLIB_PREPARE_IMPORT(CTFResourcePropTFUpdate, CTFResourceProp,source,psource);

	m_strVersion	= psource->m_strVersion;
	m_strLineup		= psource->m_strLineup;
	m_strDigest		= psource->m_strDigest;
}


void 
CTFResourcePropTFUpdate::SetVersion(const TFXMLCh* pszVersion)
{
	m_strVersion = pszVersion;
}

void 
CTFResourcePropTFUpdate::SetLineup(const TFXMLCh* pszLineup)
{
	m_strLineup = pszLineup;
}

void 
CTFResourcePropTFUpdate::SetDigest(const TFXMLCh* pszDigest)
{
	m_strDigest = pszDigest;
}

const TFXMLCh* 
CTFResourcePropTFUpdate::GetVersion(void)
{
	return m_strVersion.c_str();
}

const TFXMLCh* 
CTFResourcePropTFUpdate::GetLineup(void)
{
	return m_strLineup.c_str();
}

const TFXMLCh* 
CTFResourcePropTFUpdate::GetDigest(void)
{
	return m_strDigest.c_str();
}


