#include "TFResourcePropTFUser.h"
#include "TFLibPublic.h"

TFLIB_IMPLEMENT_CLASS(CTFResourcePropTFUser,"CTFResourcePropTFUser")

CTFResourcePropTFUser::CTFResourcePropTFUser(void)
:m_bAdmin(false),
 m_tLastAccesseDate(0),
 m_tExpiration(0),
 m_bOtheruser(false)
{
	TFLIB_CONSTRUCT_CLASS(CTFResourcePropTFUser);
	m_enuType		= TFITEM_MNG_USR;
	m_nState		= TF_USER_STATUS_NONE;
	m_enuUserType	= TF_USER_TYPE_UNKNOWN;
	m_nPriv			= TF_USER_PRIV_NONE;
}

CTFResourcePropTFUser::~CTFResourcePropTFUser(void)
{
}

void CTFResourcePropTFUser::Import(const CTFObject& source)
{
	TFLIB_PREPARE_IMPORT(CTFResourcePropTFUser, CTFResourceProp,source,psource);

	m_strUserID				= psource->m_strUserID;
	m_strUsedStorage		= psource->m_strUsedStorage;
	m_strMaxStorage			= psource->m_strMaxStorage;
	m_strUsedResources		= psource->m_strUsedStorage;
	m_strMaxResources		= psource->m_strMaxResources;
	m_strPassWord			= psource->m_strPassWord;
	m_strLastAccessedClient	= psource->m_strLastAccessedClient;
	m_bAdmin				= psource->m_bAdmin;
	m_strMailAddress		= psource->m_strMailAddress;
	m_strComment			= psource->m_strComment;
	m_tLastAccesseDate		= psource->m_tLastAccesseDate;
	m_tExpiration			= psource->m_tExpiration;			///< 有効期限
	m_nState				= psource->m_nState;				///< ステータス
	m_nPriv					= psource->m_nPriv;					///< ユーザ権限
	m_enuUserType			= psource->m_enuUserType;			///< ユーザタイプ
	m_bOtheruser			= psource->m_bOtheruser;			///< 他人ユーザ
}

void
CTFResourcePropTFUser::SetUID(const TFXMLCh* pszUserID)
{
	m_strUserID = pszUserID;
}

void
CTFResourcePropTFUser::SetPassWord(const TFXMLCh* pszPassWord)
{
	m_strPassWord = pszPassWord;
}

void
CTFResourcePropTFUser::SetStorages(const TFXMLCh* pszSize, TF_STAT_QUOTA_TYPE enuType)
{
	switch(enuType)
	{
		case TF_STAT_USED:
			m_strUsedStorage = pszSize;
			break;

		case TF_STAT_MAX:
			m_strMaxStorage	 = pszSize;
			break;

		default:
			OI_ASSERT(false);
			break;
	}
}

void
CTFResourcePropTFUser::SetResources(const TFXMLCh* pszCnt, TF_STAT_QUOTA_TYPE enuType)
{
	switch(enuType)
	{
		case TF_STAT_USED:
			m_strUsedResources = pszCnt;
			break;

		case TF_STAT_MAX:
			m_strMaxResources  = pszCnt;
			break;

		default:
			OI_ASSERT(false);
			break;
	}
}

void
CTFResourcePropTFUser::SetLastAccessClient(const TFXMLCh* pszClient)
{
	m_strLastAccessedClient = pszClient;
}

void
CTFResourcePropTFUser::SetMailAddr(const TFXMLCh* pszAddress)
{
	m_strMailAddress = pszAddress;
}

void
CTFResourcePropTFUser::SetAdminFlag(bool bAdmin)
{
	m_bAdmin = bAdmin;
}

void
CTFResourcePropTFUser::SetComment(const TFXMLCh* strComment)
{
	m_strComment = strComment;
}

void
CTFResourcePropTFUser::SetAccessDeny(const TFXMLCh* strAccessDeny)
{
	m_strAccessDeny = strAccessDeny;
}

void
CTFResourcePropTFUser::SetLastAccessDate(time_t time)
{
	m_tLastAccesseDate = time;
}

void 
CTFResourcePropTFUser::SetExpiration(time_t time)
{
	m_tExpiration = time;
}

void 
CTFResourcePropTFUser::SetStatus(TFUSERSTATUS nStatus)
{
	m_nState = nStatus;
}

void
CTFResourcePropTFUser::SetPrivilege(TFUSERPRIV nPriv)
{
	m_nPriv = nPriv;
}

void
CTFResourcePropTFUser::SetUserType(const TFXMLCh* pszUserType)
{

	m_enuUserType = TF_USER_TYPE_UNKNOWN;

	if (IS_EMPTY(pszUserType)) return;

	OI_STRING_A	strUserType = (const char*)X(pszUserType);
	for (int i=0; TFUSERTYPETABLE[i].nType != TF_USER_TYPE_UNKNOWN; i++)
	{
		if (strUserType.compare(TFUSERTYPETABLE[i].pszName) == 0)
		{
			m_enuUserType = TFUSERTYPETABLE[i].nType;
			break;
		}
	}
}

void
CTFResourcePropTFUser::SetUserType(TF_USER_TYPE enuType)
{
	m_enuUserType = enuType;
}

const TFXMLCh* CTFResourcePropTFUser::GetUID(void)
{
	return m_strUserID.c_str();
}

const TFXMLCh*
CTFResourcePropTFUser::GetPassWord(void)
{
	return m_strPassWord.c_str();
}

const TFXMLCh*	
CTFResourcePropTFUser::GetStoragesString(TF_STAT_QUOTA_TYPE enuType)
{
	switch(enuType)
	{
		case TF_STAT_USED:
			return m_strUsedStorage.c_str();
			break;

		case TF_STAT_MAX:
			return m_strMaxStorage.c_str();
			break;
	}

	return NULL;
}

TF_SIZE_T
CTFResourcePropTFUser::GetStorages(TF_STAT_QUOTA_TYPE enuType)
{
	char* pchPos = NULL;

	switch(enuType)
	{
		case TF_STAT_USED:
			m_i64tmp =  OI_STRTOUL(OI_STRING_A(X(m_strUsedStorage.c_str())).c_str(), &pchPos, 0);
			break;

		case TF_STAT_MAX:
			m_i64tmp =  OI_STRTOUL(OI_STRING_A(X(m_strMaxStorage.c_str())).c_str(), &pchPos, 0);
			break;

		default:
			break;
	}

	return m_i64tmp;
}

const TFXMLCh*
CTFResourcePropTFUser::GetResourcesString(TF_STAT_QUOTA_TYPE enuType)
{
	switch(enuType)
	{
		case TF_STAT_USED:
			return m_strUsedResources.c_str();
			break;

		case TF_STAT_MAX:
			return m_strMaxResources.c_str();
			break;
	}

	return NULL;
}

TF_SIZE_T
CTFResourcePropTFUser::GetResources(TF_STAT_QUOTA_TYPE enuType)
{
	char* pchPos = NULL;

	switch(enuType)
	{
		case TF_STAT_USED:
			m_i64tmp = OI_STRTOUL(OI_STRING_A(X(m_strUsedResources.c_str())).c_str(), &pchPos, 0);
			break;

		case TF_STAT_MAX:
			m_i64tmp = OI_STRTOUL(OI_STRING_A(X(m_strMaxResources.c_str())).c_str(), &pchPos, 0);
			break;

		default:
			break;
	}

	return m_i64tmp;
}

const TFXMLCh*
CTFResourcePropTFUser::GetLastAccessClient(void)
{
	return m_strLastAccessedClient.c_str();
}
	
const TFXMLCh*
CTFResourcePropTFUser::GetMailAddr(void)
{
	return m_strMailAddress.c_str();
}

bool
CTFResourcePropTFUser::GetAdminFlag(void)
{
	return m_bAdmin;
}

const TFXMLCh*
CTFResourcePropTFUser::GetComment(void)
{
	return m_strComment.c_str();
}

const TFXMLCh*
CTFResourcePropTFUser::GetAccessDeny(void)
{
	return m_strAccessDeny.c_str();
}

time_t
CTFResourcePropTFUser::GetLastAccessDate(void)
{
	return m_tLastAccesseDate;
}

time_t
CTFResourcePropTFUser::GetExpiration(void)
{
	return m_tExpiration;
}

TFUSERSTATUS
CTFResourcePropTFUser::GetStatus(void)
{
	return m_nState;
}

TFUSERPRIV
CTFResourcePropTFUser::GetPrivilege(void)
{
	return m_nPriv;
}

TF_USER_TYPE
CTFResourcePropTFUser::GetUserType(void)
{
	return m_enuUserType;
}

const char*
CTFResourcePropTFUser::GetUserTypeString(void)
{
	for (int i=0; TFUSERTYPETABLE[i].nType != TF_USER_TYPE_UNKNOWN; i++)
	{
		if (TFUSERTYPETABLE[i].nType == m_enuUserType)
			return TFUSERTYPETABLE[i].pszName;
	}

	return NULL;
}


void
CTFResourcePropTFUser::SetMaxuserCreation(const TFXMLCh* strSize)
{
	m_strMaxuserCreation = strSize;
}

TF_SIZE_T CTFResourcePropTFUser::GetMaxuserCreation(void)
{
	char* pchPos = NULL;

	m_i64tmp = OI_STRTOUL(OI_STRING_A(X(m_strMaxuserCreation.c_str())).c_str(), &pchPos, 0);

	return m_i64tmp;
}

const TFXMLCh*
CTFResourcePropTFUser::GetMaxuserCreationString(void)
{
	return m_strMaxuserCreation.c_str();
}

void
CTFResourcePropTFUser::SetOwnerName(const TFXMLCh* strName)
{
	m_strOwnerName = strName;
}

void
CTFResourcePropTFUser::SetOwnerID(const TFXMLCh* strID)
{
	m_strOwnerID = strID;
}

const TFXMLCh*
CTFResourcePropTFUser::GetOwnerName(void)
{
	return m_strOwnerName.c_str();
}

const TFXMLCh* 
CTFResourcePropTFUser::GetOwnerID(void)
{
	return m_strOwnerID.c_str();
}

void
CTFResourcePropTFUser::SetOtherUser(bool bIsOther)
{
	m_bOtheruser = bIsOther;
}

bool
CTFResourcePropTFUser::GetIsOtherUser(void)
{
	return m_bOtheruser;
}
