#include "TFResourceTFRootTree.h"

TFLIB_IMPLEMENT_CLASS(CTFResourceTFRootTree,"CTFResourceTFRootTree")

CTFResourceTFRootTree::CTFResourceTFRootTree(void):
						m_iDisplayOrder(0)
{
	TFLIB_CONSTRUCT_CLASS(CTFResourceTFRootTree);
}

CTFResourceTFRootTree::~CTFResourceTFRootTree(void)
{
}

void CTFResourceTFRootTree::Import(const CTFObject& source)
{
	TFLIB_PREPARE_IMPORT(CTFResourceTFRootTree,CTFResourceProp,source,psource);

	m_iDisplayOrder = psource->m_iDisplayOrder;
	m_strSQLNo		= psource->m_strSQLNo;
}

bool CTFResourceTFRootTree::SetDisplayOrder(int iNo)
{
	OI_ASSERT(iNo >0);
	m_iDisplayOrder = iNo;

	return true;
}

bool CTFResourceTFRootTree::SetFolderType(const TFXMLCh* strFolderType)
{
	OI_STRING_A strTmpFolderType = (const char*)X(strFolderType);
	for (int i=0; TF_FOLDER_TYPE_TABLE[i].pszName != NULL; i++)
	{
		if (strTmpFolderType.compare(TF_FOLDER_TYPE_TABLE[i].pszName) == 0)
		{
			m_enuType = TF_FOLDER_TYPE_TABLE[i].enuType;
			return true;
		}
	}

	return false;
}

int	 CTFResourceTFRootTree::GetDisplayOrder(void)
{
	return m_iDisplayOrder;
}

TFITEMTYPE
CTFResourceTFRootTree::GetFolderType(void)
{
	if (m_enuType == TFITEM_MNG_MELEMENT)
	{
		OI_STRING_A strDisplayName = (const char*)X(GetDisplayName());
		if (strDisplayName.compare(TF_MNG_USER) == 0)
		{
			return TFITEM_MNG_USR_ROOT;
		}

		if (strDisplayName.compare(TF_MNG_GROUP) == 0)
		{
			return TFITEM_MNG_GRP_ROOT;
		}

		if (strDisplayName.compare(TF_MNG_MSG) == 0)
		{
			return TFITEM_MNG_MSG_ROOT;
		}

		if (strDisplayName.compare(TF_MNG_STATUS) == 0)
		{
			return TFITEM_MNG_STAT_ROOT;
		}

		if (strDisplayName.compare(TF_MNG_SQL) == 0)
		{
			return TFITEM_MNG_SQL_ROOT;
		}

		if (strDisplayName.compare(TF_MNG_UPDATE) == 0)
		{
			return TFITEM_MNG_CLIENT_ROOT;
		}

		if (strDisplayName.compare(TF_MNG_DBMS) == 0)
		{
			return TFITEM_MNG_DBMS_ROOT;
		}

		if (strDisplayName.compare(TF_MNG_EXECSQL) == 0)
		{
			return TFITEM_MNG_EXECSQL_ROOT;
		}
	}

	return m_enuType;
}

void
CTFResourceTFRootTree::SetSQLNo(const TFXMLCh* pszSQLNo)
{
	m_strSQLNo = pszSQLNo;
}

const TFXMLCh*
CTFResourceTFRootTree::GetSQLNo(void)
{
	return m_strSQLNo.c_str();
}

